/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteAdvertBudgetDayHourHistioryService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.advert
 * Date:2017年8月24日下午2:57:17
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.remoteservice.advert;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.advert.ReqAdvertBudgetDayHourHistioryDto;
import cn.com.duiba.tuia.core.api.dto.rsp.advert.RspAdvertBudgetDayHourHistioryDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * ClassName:RemoteAdvertBudgetDayHourHistioryService <br/>
 * Function: 每日每小时广告状态、预算记录DUBBO接口<br/>
 * Date:     2017年8月24日 下午2:57:17 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteAdvertBudgetDayHistioryService {
    /**
     * 
     * getMaxBudgetEveryDay:查询某个时间段内广告最大历史预算、最后广告状态. <br/>
     *
     * @author chencheng
     * @param entity 查询条件
     * @return
     * @throws TuiaCoreException
     * @since JDK 1.8
     */
    DubboResult<List<RspAdvertBudgetDayHourHistioryDto>> selectAdvertBudgetEveryDay(ReqAdvertBudgetDayHourHistioryDto req);
    
    /**
     * 
     * updateAdvertBudgetDayHistory:(更新广告状态、日预算历史数据). <br/>
     *
     * @author chencheng
     * @param advertId
     * @param budgetPerDay
     * @since JDK 1.8
     */
    int updateAdvertBudgetDayHistory(Long advertId, Long budgetPerDay);

    /**
     * 根据广告ID和选择的日期查询广告每日预算数据
     * @param curDates
     * @param advertId
     * @return
     */
    List<RspAdvertBudgetDayHourHistioryDto> getAdvertBudgetEveryDay(List<String> curDates, Long advertId);
}

