package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.CanSeeAdvertIdsPermissionDto;

import java.util.List;

/**
 * @author Wangpf
 * @date 2022/11/18 9:47 上午
 */
@AdvancedFeignClient
public interface RemoteAdvertPermissionService {


    /**
     * 根据用户ID获取用户可以查看的广告(提供给大数据使用)
     * a.只有销售/AE/销售leader/AE leader才有权限，否则没有
     * b.开始时间，过滤掉广告修改时间gmt_modified<开始时间前&已失效
     * c.结束时间, 过滤掉广告创建时间gmt_create>结束时间
     *
     * @param adminId
     * @param startTime yyyy-MM-dd HH:mm:ss
     * @param endTime yyyy-MM-dd HH:mm:ss
     * @return
     */
    CanSeeAdvertIdsPermissionDto getAllCanSeeAdvertIdsByAdminId(long adminId, String startTime, String endTime);


    /**
     * 根据ssoId查询广告权限数据
     * @param ssoIds
     * @param startTime
     * @param endTime
     * @return
     */
    List<Long> getSSOCanSeeAdvertIdsByAdminId(Long userId,List<Long> ssoIds, String startTime, String endTime);

}
