package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertPlanOcpcWhiteDto;

import java.util.List;

/**
 * 描述：广告计划进OCPC门槛白名单
 *
 * @author zhouziwu
 * @date 2022-02-18
 */
@AdvancedFeignClient
public interface RemoteAdvertPlanOcpcWhiteService {
    /**
     * 查询有效的白名单
     * @param todayTime 查询时间
     * @return list
     */
    List<AdvertPlanOcpcWhiteDto> findValidAdvertPlans(String todayTime);

    /**
     * 根据计划id去查询白名单
     * @param advertPlanId 广告计划id
     * @return dto
     */
    AdvertPlanOcpcWhiteDto findByAdvertPlanId(Long advertPlanId, String today);

    /**
     * 添加白名单
     * @param dto 添加对象
     * @return int
     */
    Integer addAdvertPlanWhite(AdvertPlanOcpcWhiteDto dto);

    /**
     * 根据计划id更新白名单
     * @param dto 广告计划白名单对象
     * @return int
     */
    Integer updateByAdvertPlanId(AdvertPlanOcpcWhiteDto dto);

    /**
     * 根据计划id删除白名单
     * @param planId 广告计划id
     * @return int
     */
    Integer deleteByAdvertPlanId(Long planId);
}
