package cn.com.duiba.tuia.core.api.remoteservice.slot;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.slot.OrderCustomConfigDto;

import java.util.List;

/**
 *  券次序定制广告Remote服务接口
 *
 * @author zhangbaiqiang
 * @date 2021/6/9
 */
@AdvancedFeignClient
public interface RemoteOrderCustomAdvertService {

    /**
     * 查询所有的资源名称
     *
     * @return 资源名称列表
     */
    List<String> queryResourceNames();

    /**
     * 查询所有的新行业
     *
     * @return 新行业列表
     */
    List<String> queryNewTrades();


    /**
     * 查询券次序定制广告
     *
     * @param slotId 广告位Id
     * @return 券次序定制广告列表
     */
    List<OrderCustomConfigDto> queryConfig(Long slotId);

    /**
     * 新增或更新券次序定制广告
     *
     * @param param 配置参数（更新时id不为空）
     * @return 是否操作成功
     */
    boolean saveConfig(OrderCustomConfigDto param) throws BizException;

    /**
     * 删除券次序定制广告
     *
     * @param id 配置id
     * @return 是否操作成功
     */
    boolean deleteConfig(Long id);


    /**
     * 更新广告位的券次序定制广告开关
     *
     * @param slotId 广告位Id
     * @param status 开关状态（1.开,0.关）
     * @return 更新后的开关状态
     */
    Integer updateSwitch(Long slotId, Integer status) throws BizException;

    /**
     * 查询广告位的券次序定制广告开关状态
     *
     * @param slotId 广告位Id
     * @return 开关状态（1.开,0.关）
     */
    Integer querySwitch(Long slotId);

    /**
     * 复制广告位全次序定制
     * @param originalSlotId
     * @param targetSlotId
     * @param advertOrderCustomStatus
     * @return
     */
    Boolean copyOrderCustom(Long originalSlotId, Long targetSlotId, Integer advertOrderCustomStatus) throws BizException;
}
