package cn.com.duiba.tuia.core.api.remoteservice.wechatwork;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.wechatwork.*;

import java.util.List;

@AdvancedFeignClient
public interface RemoteWechatLinkService {

    /**
     * 新建获客链接
     *
     * @param saveDTO
     * @return
     */
    int save(WechatLinkSaveDTO saveDTO);

    /**
     * 分页查询获客链接
     *
     * @param pageDTO
     * @return
     */
    PageDto<WechatLinkDTO> page(WechatLinkPageDTO pageDTO);

    /**
     * 启用获客链接
     *
     * @param id
     * @return
     */
    int enable(Long id);

    /**
     * 禁用获客链接
     *
     * @param id
     * @return
     */
    int disable(Long id);

    Boolean putConfigEdit(WechatLinkPageDTO pageDTO);

    Boolean updateStatus(WechatLinkPageDTO pageDTO);

    String obtainLink(String linkIds, String jimuId, Integer obtainType, String tuiaId);

    String obtainLinkV2(String linkIds, String corpIds, String jimuId, Integer obtainType, String tuiaId, String deviceId);

    /**
     * 更新获客链接
     *
     * @param updateDTO
     * @return
     */
    int update(WechatLinkUpdateDTO updateDTO);

    /**
     * 企业关联的标签列表
     *
     * @param corpId
     * @param secret
     * @return
     */
    List<WechatTagDTO> listTag(String corpId, String secret);

    /**
     * 获客链接列表
     *
     * @param queryDTO
     * @return
     */
    List<WechatLinkDTO> listLink(WechatLinkQueryDTO queryDTO);
}
