package cn.com.duiba.tuia.core.api.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * 域名处理工具类
 * @author lijicong
 * @since 2020-08-03
 */
public class DomainUtil {

    /**
     * 域名替换，如： http://原始域名/xx/xx/xx  替换成 http://目标域名/xx/xx/xx
     * @param targetDomain 目标域名
     * @param promoteUrl 落地页地址
     * @return
     */
    public static String replaceDomain(String targetDomain, String promoteUrl) {
        StringBuilder sb = new StringBuilder();
        if (promoteUrl.contains("http://")) {
            // 截取 http:// 之后的地址
            String promoteUrlTemp = promoteUrl.substring(7);
            // 第一个 “/” 的下标地址
            int index = promoteUrlTemp.indexOf("/");
            sb.append("http://").append(targetDomain).append(promoteUrlTemp.substring(index));
            return sb.toString();
        }

        if (promoteUrl.contains("https://")) {
            // 截取 http:// 之后的地址
            String promoteUrlTemp = promoteUrl.substring(8);
            // 第一个 “/” 的下标地址
            int index = promoteUrlTemp.indexOf("/");
            sb.append("https://").append(targetDomain).append(promoteUrlTemp.substring(index));
            return sb.toString();
        }
        // 第一个 “/” 的下标地址
        int index = promoteUrl.indexOf("/");
        sb.append("http://").append(targetDomain).append(promoteUrl.substring(index));
        return sb.toString();
    }

    /**
     * 判断是不是JfSite落地页
     * @param promoteUrl
     * @return
     */
    public static boolean isJfSiteDoamin(String promoteUrl) {
        String pattern = "/mofang?id=";
        if (!promoteUrl.contains(pattern)) {
            return false;
        }
        int index = promoteUrl.indexOf(pattern);
        String restUrl = promoteUrl.substring(index + pattern.length());

        int lastIndex = restUrl.length();
        if (restUrl.contains("&")) {
            lastIndex = restUrl.indexOf("&");
        }

        String landPageIdStr = restUrl.substring(0, lastIndex);
        String landPageId = UrlBase64.urlBase64Decode(landPageIdStr);
        return StringUtils.isNotBlank(landPageId) && StringUtils.isNumeric(landPageId);
    }
}
