package cn.com.duiba.tuia.core.api.controller;

import cn.com.duiba.tuia.core.api.dto.wechatwork.WechatLinkAttributionDTO;
import cn.com.duiba.tuia.core.api.remoteservice.wechatwork.RemoteWechatLinkAttributionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
/**
 * @author y.zhao
 * @title: WechatLinkAttributionController
 * @projectName tuia-advert-center
 * @description: description
 * @date 2025.07.16 15:52
 */
@RestController
@RequestMapping("/wechatLink")
public class WechatLinkAttributionController {

    @Autowired
    private RemoteWechatLinkAttributionService remoteService;

    @PostMapping("/save")
    public int save(@RequestBody WechatLinkAttributionDTO dto) {
        return remoteService.save(dto);
    }

    @GetMapping("/getByExternalUserId")
    public WechatLinkAttributionDTO getByExternalUserId(@RequestParam String externalUserId) {
        return remoteService.getByExternalUserId(externalUserId);
    }

    @PostMapping("/getByCorpAndExternalUserId")
    public WechatLinkAttributionDTO getByCorpAndExternalUserId(@RequestBody WechatLinkAttributionDTO dto) {
        return remoteService.getByCorpIdAndExternalUserId(dto);
    }
}
