/**
 * Project Name:tuia-advert-center-biz File Name:AdvertEntity.java Package
 * Name:cn.com.duiba.tuia.core.biz.domain.entity.advert Date:2017年9月28日下午3:35:55 Copyright (c) 2017, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.req.orientPkg;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: AdvertPlanPeriodEntity <br/>
 * Function: 配置投放时间查询. <br/>
 * date: 2019年5月28日 下午5:03:36 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class AdvertPlanPeriodReq implements Serializable {
    
    private static final long serialVersionUID = 8873491994355230120L;
    public static final Integer QUERY_SET_NULL = 1;
    public static final Integer QUERY_NOT_SET_NULL = 0;

    /** 广告ID. */
    private Long       advertId;

    /** 广告ID集合. */
    private List<Long> advertIds;

    /** 配置ID集合. */
    private List<Long> advertPackageIds;

    /** 配置是否需要为空。0-否，1-是 */
    private Integer    advertPackageType;

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.8
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.8
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * advertIds.
     *
     * @return the advertIds
     * @since JDK 1.8
     */
    public List<Long> getAdvertIds() {
        return advertIds;
    }

    /**
     * advertIds.
     *
     * @param advertIds the advertIds to set
     * @since JDK 1.8
     */
    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }

    /**
     * advertPackageIds.
     *
     * @return the advertPackageIds
     * @since JDK 1.8
     */
    public List<Long> getAdvertPackageIds() {
        return advertPackageIds;
    }

    /**
     * advertPackageIds.
     *
     * @param advertPackageIds the advertPackageIds to set
     * @since JDK 1.8
     */
    public void setAdvertPackageIds(List<Long> advertPackageIds) {
        this.advertPackageIds = advertPackageIds;
    }

    /**
     * advertPackageType.
     *
     * @return the advertPackageType
     * @since JDK 1.8
     */
    public Integer getAdvertPackageType() {
        return advertPackageType;
    }

    /**
     * advertPackageType.
     *
     * @param advertPackageType the advertPackageType to set
     * @since JDK 1.8
     */
    public void setAdvertPackageType(Integer advertPackageType) {
        this.advertPackageType = advertPackageType;
    }

    public AdvertPlanPeriodReq(List<Long> advertIds, Integer advertPackageType) {
        this.advertIds = advertIds;
        this.advertPackageType = advertPackageType;
    }

    public AdvertPlanPeriodReq(Long advertId, Integer advertPackageType) {
        this.advertId = advertId;
        this.advertPackageType = advertPackageType;
    }

    public AdvertPlanPeriodReq(List<Long> advertPackageIds) {
        this.advertPackageIds = advertPackageIds;
    }

    public AdvertPlanPeriodReq() {

    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    
}
