package cn.com.duiba.tuia.core.api.dto.wechatwork;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class WechatLinkDTO implements Serializable {

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 创建人
     */
    private String creator;

    /**
     * 创建人id
     */
    private Long creatorId;

    /**
     * 企业id
     */
    private String corpId;

    /**
     * 链接名称
     */
    private String linkName;

    /**
     * 链接id
     */
    private String linkId;

    /**
     * 获客链接
     */
    private String link;

    private String userConf;

    /**
     * accessToken
     */
    private String accessToken;

    /**
     * 开关
     */
    private Integer enable;

    /**
     * 备注
     */
    private String remark;

    /**
     * 投放状态 0-关闭 1-开启
     */
    private Integer putStatus;
    /**
     * 投放时间
     */
    private String putTime;
    /**
     * 粉丝数量上限
     */
    private Integer fansLimit;

    private Integer newCustomerCnt;


    /**
     * 是否自动打标
     */
    private Integer autoTag;

    private String secret;

    private Integer needVerify;

    /**
     * 关联的标签id配置
     */
    private String relatedTagIdConf;

    /**
     * 客服状态
     * 0-异常 1-正常
     */
    private Integer userStatus;
}
