package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: ResourceTagsTypeEnum <br/>
 * Function: 资源对应标签类型. <br/>
 * date: 2017年7月31日 下午4:41:03 <br/>
 *
 * @author chencheng
 * @version
 */
public enum ResourceTagsTypeEnum {

    /** 广告推广链接标签 */
    AD("ad", "广告推广链接标签"),

    /** 素材标签 */
    MATERIAL("material", "素材标签"),

    /** 弹层标签 */
    WIND("wind", "弹层标签"),

    JIMU("jimu","积木同步标签"),
    
    /** 应用屏蔽的推广链接标签 */
    APP_BANNED_URL_TAG("appBannedUrlTag", "应用屏蔽的推广链接标签"),

    /** 广告分析标签 */
    ADVERT_ANALYSIS_TAG("advertAnalysisTag", "广告分析标签"),

    /** 广告位屏蔽的推广链接标签 */
    SLOT_BANNED_URL_TAG("slotBannedUrlTag", "广告位屏蔽的推广链接标签"),

    /** 广告位流量策略屏蔽的推广链接标签 */
    SLOT_FLOW_BANNED_URL_TAG("slotFlowBannedUrlTag", "广告位流量策略屏蔽的推广链接标签"),

    APP_SHIELD_MATERIAL_TAG("appShieldMaterialTag", "应用屏蔽的素材标签"),

    SLOT_FLOW_SHIELD_MATERIAL_TAG("slotFlowMaterialTag", "广告位流量策略屏蔽的素材标签"),

    SLOT_SHIELD_MATERIAL_TAG("slotMaterialTag", "应用广告位屏蔽的素材标签"),

    /** 广告资源标签 */
    ADVERT_RESOURCE_TAG("advertResourceTag", "广告资源标签"),
    AE_ADVERT_RESOURCE_TAG("aeAdvertResourceTag", "Ae打的标签-页面叫投放产品"),
    ADVERT_FEATURE("adFeature", "广告特征标签"),

    APP_BANNED_RESOURCE_TAG("appBannedResourceTag", "应用屏蔽的资源标签"),

    SLOT_FLOW_BANNED_RESOURCE_TAG("slotFlowBannedRes", "广告位流量策略屏蔽的资源标签"),

    APP_OCR_COMMON_TAG("appOcrCommonTag", "应用屏蔽的OCR通用标签"),

    APP_OCR_TRADE_TAG("appOcrTradeTag", "应用屏蔽的OCR行业标签"),
    ;

    private String desc;

    private String code;

    ResourceTagsTypeEnum(String code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, ResourceTagsTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (ResourceTagsTypeEnum it : ResourceTagsTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static ResourceTagsTypeEnum getByName(String code) {
        return enumMap.get(code);
    }
}
