package cn.com.duiba.tuia.core.api.remoteservice.land;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.land.LandPagePermissionDto;

import java.util.List;

/**
 * @author Wangpf
 * @description  落地页协同相关服务(积木使用)
 * @date 2019/8/12 14:48
 */
@AdvancedFeignClient
@SuppressWarnings("squid:S1214")
public interface RemoteLandPermissionService {

    int LAND = 0;

    int LAYER = 1;

    int INDUSTRY_TEMPLATE = 2;


    /**
     * 给当前落地页增加协同用户
     *
     * @param adminIds 落地页ID
     * @param landId 当前用户ID
     * @return 影响行数
     */
    int batchAdd(List<Long> adminIds,long landId);

    /**
     *   根据场景给当前落地页或弹层增加协同用户
     * @return
     */
    int batchSave(List<Long> adminIds,long landId,Integer scene);


    /**
     * 查询当前用户拥有的协同选前的落地页
     *
     * @param adminId 当前用户ID
     * @return 当前用户可以拥有协同权限的落地页
     */
    List<Long>  listAllPermissionByAdminId(long adminId);

    /**
     * 查询当前拥有当前落地页协同的管理员
     *
     * @param landId 当前用户ID
     * @return 查询当前拥有当前落地页协同的管理员
     */
    List<Long>  listAllPermissionByLandId(long landId);

    /**
     * 查询当前用户拥有的协同选前的落地页
     *
     * @param adminId 当前用户ID
     * @return 当前用户可以拥有协同权限的落地页
     */
    List<Long>  listAllPermissionByAdminIdAndScene(long adminId,Integer scene);

    /**
     * 查询当前拥有当前落地页协同的管理员
     *
     * @param landId 当前用户ID
     * @return 查询当前拥有当前落地页协同的管理员
     */
    List<Long>  listAllPermissionByLandIdAndScene(long landId,Integer scene);

    /**
     * 查询当前拥有当前落地页协同的管理员(批量查询)
     *
     * @param landIds 当前用户ID
     * @return 查询当前拥有当前落地页协同的管理员
     */
    List<LandPagePermissionDto>  listAllPermissionByLandIdListAndScene(List<Long> landIds, Integer scene);
}
