package cn.com.duiba.tuia.core.api.remoteservice.orientPkg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.OrientPkgPeoplePkgRelationDto;
import cn.com.duiba.tuia.core.api.dto.UserTfFilterDto;
import cn.com.duiba.tuia.core.api.dto.orientPkg.AdxOrientDataDTO;
import cn.com.duiba.tuia.core.api.dto.orientPkg.OrientDataNewDto;
import cn.com.duiba.tuia.core.api.enums.OrientPeoplePkgSourceEnum;

import java.util.List;

/**
 * 
 * Function: 定向配置定向人群关系表. <br/>
 *
 * @author xuxx
 * @version 
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteOrientPkgPeoplePkgRelationService {

    /**
     * 根据配置id查询
     * @param orientId
     * @return
     */
    List<OrientPkgPeoplePkgRelationDto> obtainRelationByOrientPkgId(Long orientId);

    /**
     * 根据人群包id 和 来源查询
     * @return
     */
    List<OrientPkgPeoplePkgRelationDto> obtainRelationByPeoplePkgIdAndSource(String peoplePkgId, OrientPeoplePkgSourceEnum Source);

    /**
     * 提交选中的定向人群包
     * @return
     */
    Integer submitPickedPeoplePkg(Long orientId ,List<OrientPkgPeoplePkgRelationDto> orientPkgPeoplePkgRelationDtos);


    /**
     * 批量 提交选中的定向人群包
     * @return
     */
    Integer submitPickedPeoplePkgs(List<Long> orientIds ,List<OrientPkgPeoplePkgRelationDto> orientPkgPeoplePkgRelationDtos);


    /**
     * 批量 提交已转化人群过滤
     * @deprecated
     * 此方式作为上线兼容方法, 请使用 cn.com.duiba.tuia.core.api.remoteservice.orientPkg.RemoteOrientPkgPeoplePkgRelationService#submitUserTfFiltersNew(java.util.List, java.lang.String, java.util.List, java.util.List)
     */
    @Deprecated
    Integer submitUserTfFilters(List<Long> orientIds ,String type,List<String> target);

    /**
     * 批量 提交已转化人群过滤
     */
    Integer submitUserTfFiltersNew(List<Long> orientIds ,String type,List<String> target,List<String> targetPeriod);

    /**
     * 根据配置id 查询 已转化过滤人群
     * @param orientIds
     * @return
     */
    UserTfFilterDto obtainUserTfFilterByOrientId(Long orientIds);

    /**
     * 查询 选中的 adx定向数据
     * @param orientId
     * @return
     */
    List<AdxOrientDataDTO> getCheckedADXOrientData(Long orientId);

    /**
     * 批量提交 配置选中的定向adx数据
     */
    Integer submitAdxOrientData(Long orientId, List<AdxOrientDataDTO> submitDatas);

    /**
     * 查询广告对应的人群包配置
     * @param orientPkgIds
     * @return
     */
    List<OrientDataNewDto> getAdvertOrient(List<Long> orientPkgIds);

}

