/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteQualificationResourceService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.qualification
 * Date:2017年12月1日上午9:58:05
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.remoteservice.qualification;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.req.qualification.ReqQualificationResource;
import cn.com.duiba.tuia.core.api.dto.req.qualification.ReqQualificationResourceDto;
import cn.com.duiba.tuia.core.api.dto.rsp.account.QualificationResourceDto;

import java.util.List;

/**
 * ClassName:RemoteQualificationResourceService <br/>
 * Function: 资质资源信息接口. <br/>
 * Date:     2017年12月1日 上午9:58:05 <br/>
 * @author chencheng
 * @version
 * @since JDK 1.8
 * @see
 */
@AdvancedFeignClient
public interface RemoteQualificationResourceService {
    /**
     * selectQualificationResource:(查询所有的资质资源信息). <br/>
     *
     * @author chencheng
     * @return
     * @since JDK 1.8
     */
    List<QualificationResourceDto> selectAllQualificationResource();

    /**
     *
     * selectQualificationResource:(条件查询资质资源信息). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @since JDK 1.8
     */
    List<QualificationResourceDto> selectQualificationResource(ReqQualificationResourceDto dto);

    /**
     * 根据条件查询资质资源数据数量
     * @param req
     * @return
     */
    Integer getQualificationCount(ReqQualificationResource req);

    /**
     * 根据条件分页查询资质资源数据
     * @param req
     * @return
     */
    List<QualificationResourceDto> getQualificationLimit(ReqQualificationResource req);

    /**
     * 新增资质资源信息
     * @param dto
     * @return
     */
    Integer insert(QualificationResourceDto dto);

    /**
     * 更新资质资源信息
     * @param dto
     * @return
     */
    Integer update(QualificationResourceDto dto);

    /**
     * 根据父id列表查询所有的资质资源信息
     * @param parentIds
     * @return
     */
    List<QualificationResourceDto> getQualificationResourceByParentIds(List<Long> parentIds);

    /**
     * 根据条件判断资质要求是否存在
     * @param req
     * @return
     */
    Boolean checkQualification(QualificationResourceDto req);

    /**
     * 分页查询资质行业
     */
    PageDto<QualificationResourceDto> selectQualificationTrade(ReqQualificationResource req);
}

