package cn.com.duiba.tuia.core.api.remoteservice.wechat;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 微信二维码相关接口
 */
@AdvancedFeignClient
public interface RemoteWechatQrcodeService {

    /**
     *
     * 生成带参数的小程序码
     * @param authorizerAppId 授权方方小程序appId
     * @param page 授权方小程序页面（例如 pages/index/index）
     * @param scene 要传递的参数（最大32个可见字符，只支持数字，大小写英文以及部分特殊字符：!#$&'()*+,/:;=?@-._~）
     * @return
     */
    String getMiniProgramQrcode(String authorizerAppId, String page, String scene) throws BizException;
}
