/**
 * 文件名：AdvertMaterailStatisticsRsp.java 此类描述的是:广告素材统计数据. 作者: chencheng 创建时间: 2017年9月6日 上午10:35:26
 */
package cn.com.duiba.tuia.core.api.statistics.domain;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: AdvertMaterailStatisticsRsp <br/>
 * Function: 广告素材统计数据. <br/>
 * date: 2017年9月6日 上午10:35:26 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class AdvertMaterialStatisticsRsp extends AdvertStatisticsData {

    private static final long serialVersionUID = 8657221159926325195L;

    /** 素材ID. */
    private Long              materialId;

    /** 素材名称. */
    private String            materialName;

    /** 素材预览. */
    private String            bannerPng;

    /** 素材标签. */
    private List<String>      materialTags;

    /**
     * 素材的设计
     */
    private String designer;

    /** 激活状态 */
    private Integer           isActivate;

    /** 广告ID. */
    private Long              advertId;

    //广告类型
    private Integer advertType;

    /** 广告名称. */
    private String            advertName;

    /** 广告主ID. */
    private Long              advertiserId;

    /** 广告主邮箱. */
    private String            advertiserEmail;

    /** 广告主名称. */
    private String            companyName;

    /** 代理商名称. */
    private String            agentCompanyName;

    /** 代理商邮箱. */
    private String            agentEmail;

    /** 当前日期. */
    private Date              curDate;
    
    /** 新行业ID */
    private Long              newTradeId;

    /** 新行业名称 */
    private String            newTradeName;

    /** 二级行业标签 */
    private String            matchTagName;

    /**素材ctr诊断结果，如：好、差、一般、很差、不确定等 */
    private String              diagnosisCtrResult;

    /** 素材ctr诊断的详细内容 */
    private String              diagnosisCtrContent;

    /** 素材cvr诊断结果，如：好、差、一般、很差、不确定等 */
    private String              diagnosisCvrResult;

    /** 素材cvr诊断的详细内容 */
    private String              diagnosisCvrContent;

    /** 行业top1 同流量CTR信息*/
    private String              tradeTopOneCtr;

    /** 同流量下的ctr top1的素材id */
    private String              tradeTopOneCtrMaterialId;

    /** 行业top1 同流量CVR信息 */
    private String              tradeTopOneCvr;

    /** 同流量下的cvr top1的素材id */
    private String              tradeTopOneCvrMaterialId;

    /** 行业平均ctr信息 */
    private String              tradeAverageCtr;

    /** 行业平均cvr信息 */
    private String              tradeAverageCvr;

    /**广告失效状态zm*/
    private Boolean abate;

    /**
     * 付款金额
     */
    private BigDecimal paymentAmount;

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public Boolean getAbate() {
        return abate;
    }

    public void setAbate(Boolean abate) {
        this.abate = abate;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    public String getMatchTagName() {
        return matchTagName;
    }

    public void setMatchTagName(String matchTagName) {
        this.matchTagName = matchTagName;
    }

    /**
     * newTradeId.
     *
     * @return  the newTradeId
     * @since   JDK 1.8
     */
    public Long getNewTradeId() {
        return newTradeId;
    }
    
    /**
     * newTradeId.
     *
     * @param   newTradeId    the newTradeId to set
     * @since   JDK 1.8
     */
    public void setNewTradeId(Long newTradeId) {
        this.newTradeId = newTradeId;
    }

    
    /**
     * newTradeName.
     *
     * @return  the newTradeName
     * @since   JDK 1.8
     */
    public String getNewTradeName() {
        return newTradeName;
    }

    
    /**
     * newTradeName.
     *
     * @param   newTradeName    the newTradeName to set
     * @since   JDK 1.8
     */
    public void setNewTradeName(String newTradeName) {
        this.newTradeName = newTradeName;
    }

    public String getTradeTopOneCtrMaterialId() {
        return tradeTopOneCtrMaterialId;
    }

    public void setTradeTopOneCtrMaterialId(String tradeTopOneCtrMaterialId) {
        this.tradeTopOneCtrMaterialId = tradeTopOneCtrMaterialId;
    }

    public String getTradeTopOneCvrMaterialId() {
        return tradeTopOneCvrMaterialId;
    }

    public void setTradeTopOneCvrMaterialId(String tradeTopOneCvrMaterialId) {
        this.tradeTopOneCvrMaterialId = tradeTopOneCvrMaterialId;
    }

    public String getTradeTopOneCtr() {
        return tradeTopOneCtr;
    }

    public void setTradeTopOneCtr(String tradeTopOneCtr) {
        this.tradeTopOneCtr = tradeTopOneCtr;
    }

    public String getTradeTopOneCvr() {
        return tradeTopOneCvr;
    }

    public void setTradeTopOneCvr(String tradeTopOneCvr) {
        this.tradeTopOneCvr = tradeTopOneCvr;
    }

    public String getTradeAverageCtr() {
        return tradeAverageCtr;
    }

    public void setTradeAverageCtr(String tradeAverageCtr) {
        this.tradeAverageCtr = tradeAverageCtr;
    }

    public String getTradeAverageCvr() {
        return tradeAverageCvr;
    }

    public void setTradeAverageCvr(String tradeAverageCvr) {
        this.tradeAverageCvr = tradeAverageCvr;
    }

    /**
     * advertiserEmail.
     *
     * @return the advertiserEmail
     * @since JDK 1.8
     */
    public String getAdvertiserEmail() {
        return advertiserEmail;
    }

    /**
     * advertiserEmail.
     *
     * @param advertiserEmail the advertiserEmail to set
     * @since JDK 1.8
     */
    public void setAdvertiserEmail(String advertiserEmail) {
        this.advertiserEmail = advertiserEmail;
    }

    public String getDiagnosisCtrResult() {
        return diagnosisCtrResult;
    }

    public void setDiagnosisCtrResult(String diagnosisCtrResult) {
        this.diagnosisCtrResult = diagnosisCtrResult;
    }

    public String getDiagnosisCtrContent() {
        return diagnosisCtrContent;
    }

    public void setDiagnosisCtrContent(String diagnosisCtrContent) {
        this.diagnosisCtrContent = diagnosisCtrContent;
    }

    public String getDiagnosisCvrResult() {
        return diagnosisCvrResult;
    }

    public void setDiagnosisCvrResult(String diagnosisCvrResult) {
        this.diagnosisCvrResult = diagnosisCvrResult;
    }

    public String getDiagnosisCvrContent() {
        return diagnosisCvrContent;
    }

    public void setDiagnosisCvrContent(String diagnosisCvrContent) {
        this.diagnosisCvrContent = diagnosisCvrContent;
    }

    /**
     * agentEmail.
     *
     * @return the agentEmail
     * @since JDK 1.8
     */
    public String getAgentEmail() {
        return agentEmail;
    }

    /**
     * agentEmail.
     *
     * @param agentEmail the agentEmail to set
     * @since JDK 1.8
     */
    public void setAgentEmail(String agentEmail) {
        this.agentEmail = agentEmail;
    }

    /**
     * materialId.
     *
     * @return the materialId
     * @since JDK 1.8
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * materialId.
     *
     * @param materialId the materialId to set
     * @since JDK 1.8
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * materialName.
     *
     * @return the materialName
     * @since JDK 1.8
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * materialName.
     *
     * @param materialName the materialName to set
     * @since JDK 1.8
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    /**
     * materialTags.
     *
     * @return the materialTags
     * @since JDK 1.8
     */
    public List<String> getMaterialTags() {
        return materialTags;
    }

    /**
     * materialTags.
     *
     * @param materialTags the materialTags to set
     * @since JDK 1.8
     */
    public void setMaterialTags(List<String> materialTags) {
        this.materialTags = materialTags;
    }

    /**
     * isActivate.
     *
     * @return the isActivate
     * @since JDK 1.8
     */
    public Integer getIsActivate() {
        return isActivate;
    }

    /**
     * isActivate.
     *
     * @param isActivate the isActivate to set
     * @since JDK 1.8
     */
    public void setIsActivate(Integer isActivate) {
        this.isActivate = isActivate;
    }

    /**
     * bannerPng.
     *
     * @return the bannerPng
     * @since JDK 1.8
     */
    public String getBannerPng() {
        return bannerPng;
    }

    /**
     * bannerPng.
     *
     * @param bannerPng the bannerPng to set
     * @since JDK 1.8
     */
    public void setBannerPng(String bannerPng) {
        this.bannerPng = bannerPng;
    }

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.8
     */
    @Override
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.8
     */
    @Override
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * advertName.
     *
     * @return the advertName
     * @since JDK 1.8
     */
    public String getAdvertName() {
        return advertName;
    }

    /**
     * advertName.
     *
     * @param advertName the advertName to set
     * @since JDK 1.8
     */
    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    /**
     * advertiserId.
     *
     * @return the advertiserId
     * @since JDK 1.8
     */
    public Long getAdvertiserId() {
        return advertiserId;
    }

    /**
     * advertiserId.
     *
     * @param advertiserId the advertiserId to set
     * @since JDK 1.8
     */
    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    /**
     * companyName.
     *
     * @return the companyName
     * @since JDK 1.8
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * companyName.
     *
     * @param companyName the companyName to set
     * @since JDK 1.8
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * agentCompanyName.
     *
     * @return the agentCompanyName
     * @since JDK 1.8
     */
    public String getAgentCompanyName() {
        return agentCompanyName;
    }

    /**
     * agentCompanyName.
     *
     * @param agentCompanyName the agentCompanyName to set
     * @since JDK 1.8
     */
    public void setAgentCompanyName(String agentCompanyName) {
        this.agentCompanyName = agentCompanyName;
    }

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.8
     */
    public Date getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.8
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);

    }

}
