package cn.com.duiba.tuia.core.api.utils;

import cn.com.duiba.tuia.core.api.dto.advertZeroStart.AdvertZeroStartTransformDayConfigCommonDTO;
import cn.com.duiba.tuia.core.api.enums.SubTypeReflectEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * 抽取指定对象中subType对应的值
 *
 * @author Wangpf
 * @date 2022/12/27 5:20 下午
 */
public abstract class ExtractSubTypeValueUtils<T> {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractSubTypeValueUtils.class);

    /**
     * 这个方法可以写的更抽象一些，将传入的对象和枚举写的更通用一些
     *
     * @param subType 转化类型
     * @param configDTO
     * @return
     */
    public static Integer extractSubTypeValue(Integer subType, AdvertZeroStartTransformDayConfigCommonDTO configDTO) {
        if (subType == null || configDTO == null) {
            throw new IllegalArgumentException("参数非法");
        }

        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(AdvertZeroStartTransformDayConfigCommonDTO.class);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();

            String filed = SubTypeReflectEnum.getFiledBySubType(subType);
            if (filed == null) {
                throw new IllegalArgumentException("未根据转化目标找到对应的字段");
            }

            Optional<PropertyDescriptor> optional = Arrays.stream(propertyDescriptors).filter(Objects::nonNull).filter(
                    //getAaaa 这里是getaaa 所以这里忽略大小写比较
                    propertyDescriptor -> propertyDescriptor.getReadMethod().getName().equalsIgnoreCase("get" + filed)
            ).findFirst();

            if (optional.isPresent()) {
                PropertyDescriptor propertyDescriptor = optional.get();
                Method readMethod = propertyDescriptor.getReadMethod();
                Object value = readMethod.invoke(configDTO);
                return value == null ? null : Integer.valueOf(value.toString());
            }

        } catch (Exception e) {
            LOGGER.warn("extractSubTypeValue error,subType:{}", subType, e);
        }

        return null;
    }

}
