package cn.com.duiba.tuia.core.api.utils;

import java.math.BigDecimal;

/**
 * @author Wangpf
 * @date 2022/10/20 3:12 下午
 */
public abstract class NumberUtils {

    /**
     * 把两个Integer相减返回结果,null视为0
     * @param val1
     * @param val2
     * @return
     */
    public static Integer subtract(Integer val1, Integer val2) {
        Integer tmpVal1 = val1 != null ? val1 : 0;
        Integer tmpVal2 = val2 != null ? val2 : 0;
        return tmpVal1 - tmpVal2;
    }

    /**
     * 把两个Long相减返回结果,null视为0
     * @param val1
     * @param val2
     * @return
     */
    public static Long subtract(Long val1, Long val2) {
        Long tmpVal1 = val1 != null ? val1 : 0;
        Long tmpVal2 = val2 != null ? val2 : 0;
        return tmpVal1 - tmpVal2;
    }

    /**
     * 把两个Long相除返回结果,null视为0
     * @param val1
     * @param val2
     * @return
     */
    public static String divide(Long val1, Long val2) {
        Long tmpVal1 = val1 != null ? val1 : 0;
        Long tmpVal2 = val2 != null ? val2 : 0;
        if(tmpVal2 == 0L){
            return "0";
        }
        return new BigDecimal(tmpVal1).divide(new BigDecimal(tmpVal2)).toString();
    }
}
