package cn.com.duiba.tuia.core.api.dto.media.response;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * @author lijicong
 * @since 2021-04-25
 */
@Data
public class MediaAdvertInfoDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    /** 媒体ID */
    private Long appId;
    /** 广告位ID */
    private Long slotId;
    /** 广告ID */
    private Long advertId;
    /** 状态 */
    private Integer statusType;
    /** 广告名称 */
    private String advertName;
    /** 广告推广链接 */
    private String promoteUrl;
    /** 账户ID */
    private Long accountId;
    /** 账户名称 */
    private String companyName;

    //落地页ID
    private Long landPageId;
    /**
     * 巡查链接类型 0-落地页;1-二次跳转页面;2-配置落地页;3-ABTest落地页;4-素材绑定落地页;5-新媒体落地页
     */
    private Integer urlType;

    //广告关联的广告位id列表
    private List<Long> slotIds;
    //广告关联的应用id列表
    private Set<Long> appIds;
}
