package cn.com.duiba.tuia.core.api.enums;

import lombok.Getter;

import java.util.Objects;

@Getter
public enum ObtainLinkTypeEnum {

    CONSUMER_COUNT(1, "按进粉量均匀分配"),

    VISIT_COUNT(2, "按访问量均匀分配"),
    ;

    private final Integer code;

    private final String desc;

    ObtainLinkTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ObtainLinkTypeEnum fromCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (ObtainLinkTypeEnum obtainLinkTypeEnum : ObtainLinkTypeEnum.values()) {
            if (Objects.equals(code, obtainLinkTypeEnum.getCode())) {
                return obtainLinkTypeEnum;
            }
        }
        return null;
    }
}
