package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdPackageBaseInfoDTO;
import cn.com.duiba.tuia.core.api.dto.AdvertPackageDelDTO;
import cn.com.duiba.tuia.core.api.dto.activity.pack.AdvertActivityPackageBindInfo;
import cn.com.duiba.tuia.core.api.dto.appPackage.AdvertPackageBindInfo;
import cn.com.duiba.tuia.core.api.dto.req.app.ReqActivityPackageAddAdvert;
import cn.com.duiba.tuia.core.api.dto.req.app.ReqUpdateActivityFlowOrientPkg;

import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2024/9/20
 * @Description
 **/
@AdvancedFeignClient
public interface RemoteAdvertActivityPackageService {

    Boolean delete(AdvertPackageDelDTO advertPackageDelDTO);

    AdPackageBaseInfoDTO queryByPackageId(Long packageId);

    Boolean add(ReqActivityPackageAddAdvert reqActivityPackageAddAdvert);

    Boolean isAnyAdvertInUse(Long packageId);

    Boolean updateActivityFlowOrientPkg(ReqUpdateActivityFlowOrientPkg reqUpdateActivityFlowOrientPkg);

    /**
     * 根据配置更新定向限流媒体配置
     * @param advertId
     * @param orientPkgId
     * @param appOrientationIds
     * @param appFlowLimitIds
     * @return
     */
    Boolean updateActivityPackageByPkId(Long advertId, Long orientPkgId, List<Long> appOrientationIds, List<Long> appFlowLimitIds);

    AdvertActivityPackageBindInfo getAdvertPackageBindInfo(Long orientPkgId, Long advertId);

}
