package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.backflowManualRecord.BackflowManualRecordDTO;
import cn.com.duiba.tuia.core.api.dto.backflowManualRecord.BackflowManualRecordFormDTO;
import cn.com.duiba.tuia.core.api.dto.backflowManualRecord.BackflowManualRecordQueryDTO;
import cn.com.duiba.tuia.core.api.vo.TodayBackflowStatisticVo;

import java.util.List;

/**

 */
@AdvancedFeignClient
public interface RemoteBackflowManualRecordService {

    BackflowManualRecordDTO queryById(Long id);

    List<BackflowManualRecordDTO> queryList(BackflowManualRecordQueryDTO queryDTO);

    long queryCount(BackflowManualRecordQueryDTO queryDTO);

    int save(BackflowManualRecordFormDTO formDTO);

    PageDto<BackflowManualRecordDTO> pageList(BackflowManualRecordQueryDTO queryDTO);

    /**
     * 今日所有已回流曝光数据
     * @return
     */
    Long getTodaySumExposurePv();

    /**
     * 获取当日已回流数据
     * @param advertId
     * @param orientPackageId
     * @param slotId
     * @return
     */
    TodayBackflowStatisticVo getTodayBackflowStatistic(Long advertId, Long orientPackageId,String slotId);

}