package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertTimedTaskDTO;
import cn.com.duiba.tuia.core.api.dto.advert.req.AdvertTimedTaskQueryReq;
import cn.com.duiba.tuia.core.api.dto.advert.req.AdvertTimedTaskUpsertReq;

import java.util.List;
import java.util.Map;

/**
 * @author y.zhao
 * @title: RemoteAdvertTimedTaskService
 * @projectName tuia-advert-center
 * @description: 广告配置 定时任务
 * @date 2024.05.09 11:00
 */
@AdvancedFeignClient
public interface RemoteAdvertTimedTaskService {

    /**
     * 更新/插入 定时任务
     *
     * @param req
     * @return
     */
    Boolean upsertTask(AdvertTimedTaskUpsertReq req);

    /**
     * 查询任务列表
     *
     * @param req
     * @return
     */
    List<AdvertTimedTaskDTO> queryTasks(AdvertTimedTaskQueryReq req);

    /**
     * 根据广告id列表 返回map
     *
     * @param advertIds (不要太大，太大了再做优化）
     * @return <advertId,list>  </advertId,list>
     */
    Map<Long, List<AdvertTimedTaskDTO>> getTaskMapByAdvertIds(List<Long> advertIds);
}
