package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertOrientationPackageDto;
import cn.com.duiba.tuia.core.api.dto.SlotDirectAndLimitDTO;

import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2024/11/27
 * @Description
 **/
@AdvancedFeignClient
public interface RemoteSlotDirectOrLimitService {

    SlotDirectAndLimitDTO getSlotDirectAndLimit(Long pkgId);

    List<AdvertOrientationPackageDto> canAddOrientBySlotId(Long advertId, Long slotId);

    List<AdvertOrientationPackageDto> canRemoveOrientBySlotId(Long advertId, Long slotId);

    Boolean addSlotToLimit(List<Long> pkgIds, Long slotId, Long advertId);

    Boolean rmSlotToLimit(List<Long> pkgIds, Long slotId, Long advertId);
}
