package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AccountFinanceDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by huangch on 2017/8/18 16:00
 * description: 代理商账户服务
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAccountFinanceBackendService {

    /**
     * 插入代理商账户表
     *
     * @param accountFinance account_id 必传
     *                       balance 必传
     *                       budget_per_day 必传
     *                       gmt_create 必传
     *                       gmt_modified 必传
     * @return true:插入成功， false:插入失败
     */
    DubboResult<Boolean> insert(AccountFinanceDto accountFinance);

    /**
     * 查询代理商或者广告主账户余额等信息
     *
     * @param accountId 代理商或者广告主id 必传
     * @return AccountFinanceDto 代理商或者广告主账户余额信息
     */
    DubboResult<AccountFinanceDto> getBankByAccountId(Long accountId);

    /**
     * 更新代理商或者广告主的账户财务信息
     *
     * @param accountFinance accountId 必传
     * @return 更新数量
     */
    DubboResult<Integer> updateAccountFinance(AccountFinanceDto accountFinance);

    /**
     * 更具代理商id更新代理商余额信息
     *
     * @param accountId 代理商ID
     * @param balance   余额
     * @return
     */
    DubboResult<Integer> updateAccountFinanceByAccountId(Long accountId, Long balance);

    /**
     * 广告主账户余额
     *
     * @param accountId 广告主id 必传
     */
    Long getBalanceByAccountId(Long accountId);
}
