package cn.com.duiba.tuia.core.api.remoteservice.wechatwork;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.wechatwork.WechatTagMappingDTO;
import cn.com.duiba.tuia.core.api.dto.wechatwork.WechatTagMappingPageDTO;
import cn.com.duiba.tuia.core.api.dto.wechatwork.WechatTagMappingSaveDTO;

import java.util.List;

@AdvancedFeignClient
public interface RemoteWechatTagMappingService {

    /**
     * 分页查询
     *
     * @param pageDTO
     * @return
     */
    PageDto<WechatTagMappingDTO> page(WechatTagMappingPageDTO pageDTO);

    /**
     * 新建
     *
     * @param saveDTO@return
     */
    int insert(WechatTagMappingSaveDTO saveDTO);

    /**
     * 更新
     *
     * @param wechatTagMappingDTO
     * @return
     */
    int update(WechatTagMappingDTO wechatTagMappingDTO);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    int delete(Long id);

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    WechatTagMappingDTO getById(Long id);

    /**
     * 查询数量
     *
     * @param pageDTO
     * @return
     */
    int count(WechatTagMappingPageDTO pageDTO);
}
