/**
 * Project Name:manager-domain File Name:GetDailyDataRsp.java Package Name:cn.com.duiba.tuia.manager.rsp
 * Date:2016年5月24日下午4:15:16 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.statistics.domain;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.math.BigDecimal;
import java.util.List;

/**
 * ClassName:GetDailyDataRsp <br/>
 * Function: 查询每日统计数据返回结果. <br/>
 * Date: 2016年5月24日 下午4:15:16 <br/>
 *
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
public class GetDailyDataRsp extends AdvertStatisticsData {

    private static final long     serialVersionUID = 2435384644778678934L;

    /**
     * 日期 格式：yyy-mm-dd./兑换券名称
     */
    private String                date;

    /** 当前日期. */
    private String                curDate;

    /** The children. */
    private List<GetDailyDataRsp> children;

    /** 兑吧优惠券ID. */
    private Long                  itemId;

    /** 预算 */
    private Long                  budget;

    /** 广告状态名称，用于页面展示 */
    private String                validStatusName;

    /** 实际消费 */
    private BigDecimal            correctionTotal;

    /**
     * 付费金额
     */
    private BigDecimal            paymentAmount;

    /**
     * 投放roi
     */
    private BigDecimal            roi;

    public BigDecimal getRoi() {
        return roi;
    }

    public void setRoi(BigDecimal roi) {
        this.roi = roi;
    }

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    /**
     * correctionTotal.
     *
     * @return the correctionTotal
     * @since JDK 1.8
     */
    public BigDecimal getCorrectionTotal() {
        return correctionTotal;
    }

    /**
     * correctionTotal.
     *
     * @param correctionTotal the correctionTotal to set
     * @since JDK 1.8
     */
    public void setCorrectionTotal(BigDecimal correctionTotal) {
        this.correctionTotal = correctionTotal;
    }

    /**
     * validStatusName.
     *
     * @return the validStatusName
     * @since JDK 1.8
     */
    public String getValidStatusName() {
        return validStatusName;
    }

    /**
     * validStatusName.
     *
     * @param validStatusName the validStatusName to set
     * @since JDK 1.8
     */
    public void setValidStatusName(String validStatusName) {
        this.validStatusName = validStatusName;
    }

    /**
     * budget.
     *
     * @return the budget
     * @since JDK 1.8
     */
    public Long getBudget() {
        return budget;
    }

    /**
     * budget.
     *
     * @param budget the budget to set
     * @since JDK 1.8
     */
    public void setBudget(Long budget) {
        this.budget = budget;
    }

    /**
     * Gets the date.
     *
     * @return the date
     */
    public String getDate() {
        return date;
    }

    /**
     * Sets the date.
     *
     * @param date the date
     */
    public void setDate(String date) {
        this.date = date;
    }

    /**
     * Gets the cur date.
     *
     * @return the cur date
     */
    public String getCurDate() {
        return curDate;
    }

    /**
     * Sets the cur date.
     *
     * @param curDate the cur date
     */
    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    /**
     * Gets the children.
     *
     * @return the children
     */
    public List<GetDailyDataRsp> getChildren() {
        return children;
    }

    /**
     * Sets the children.
     *
     * @param children the children
     */
    public void setChildren(List<GetDailyDataRsp> children) {
        this.children = children;
    }

    /**
     * Gets the item id.
     *
     * @return the item id
     */
    public Long getItemId() {
        return itemId;
    }

    /**
     * Sets the item id.
     *
     * @param itemId the item id
     */
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {

        return ToStringBuilder.reflectionToString(this);
    }

}
