package cn.com.duiba.tuia.core.api.utils;

import cn.com.duiba.wolf.utils.ClassUtils;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * @Author:zhangmeng
 * @Date:2018-07-12
 * @Function:处理图片
 */
public class ImageUtils {
    private static final Logger logger=LoggerFactory.getLogger(ImageUtils.class);

    /**
     *
     * @param inputStream 文件流
     * @param fileType    图片类型
     * @param FoutRate    压缩比
     * @return
     * @throws Exception
     */
    public static InputStream  compassImage(InputStream inputStream,InputStream backupStream,String fileType,float FoutRate)throws IOException {
        int originSize=inputStream.available();
        //gif格式或者图片小于50kb 不给压缩
        if(originSize<=51200 || "gif".equals(fileType)){
            return inputStream;
        }
        BufferedImage bufImg = ImageIO.read(inputStream);// 把图片读入到内存中
        bufImg = Thumbnails.of(bufImg).height(bufImg.getHeight()).width(bufImg.getWidth()).keepAspectRatio(true).outputQuality(FoutRate).asBufferedImage();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();// 存储图片文件byte数组
        ImageIO.write(bufImg, fileType, bos); // 图片写入到 ImageOutputStream
        inputStream = new ByteArrayInputStream(bos.toByteArray());
        int size=inputStream.available();
        logger.info("ImageUtils.compassImage...originSize:{},size:{}",originSize,size);
        //图片压缩过了，也不给压缩
        if(size>=originSize){
            return backupStream;
        }
        return inputStream;
    }

//    public static void main(String[] args) {
//        ClassUtils.checkSerializable("cn.com.duiba.tuia.core.api.dto");
//    }
}
