/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.api.utils;

import cn.com.duiba.tuia.core.api.dto.advertZeroStart.AdvertZeroStartTransformDayConfigCommonDTO;
import cn.com.duiba.tuia.core.api.enums.SubTypeReflectEnum;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtractSubTypeValueUtils<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractSubTypeValueUtils.class);

    public static Integer extractSubTypeValue(Integer subType, AdvertZeroStartTransformDayConfigCommonDTO configDTO) {
        if (subType == null || configDTO == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5");
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(AdvertZeroStartTransformDayConfigCommonDTO.class);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            String filed = SubTypeReflectEnum.getFiledBySubType(subType);
            if (filed == null) {
                throw new IllegalArgumentException("\u672a\u6839\u636e\u8f6c\u5316\u76ee\u6807\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5");
            }
            Optional<PropertyDescriptor> optional = Arrays.stream(propertyDescriptors).filter(Objects::nonNull).filter(propertyDescriptor -> propertyDescriptor.getReadMethod().getName().equalsIgnoreCase("get" + filed)).findFirst();
            if (optional.isPresent()) {
                PropertyDescriptor propertyDescriptor2 = optional.get();
                Method readMethod = propertyDescriptor2.getReadMethod();
                Object value = readMethod.invoke((Object)configDTO, new Object[0]);
                return value == null ? null : Integer.valueOf(value.toString());
            }
        }
        catch (Exception e) {
            LOGGER.warn("extractSubTypeValue error,subType:{}", (Object)subType, (Object)e);
        }
        return null;
    }
}

