package cn.com.duiba.tuia.adx.center.api.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 素材类型
 */
public enum MaterialEnum {
    TITLE(1,"标题"),
    IMAGE(3,"图片"),
    BRAND(2,"品牌"),
    DESC(4,"描述");

    private Integer code;

    private String desc;

    MaterialEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer getTypeByDesc(String desc){
        for(MaterialEnum materialEnums : MaterialEnum.values()){
            if(StringUtils.isNoneBlank(desc) && desc.equals(MaterialEnum.TITLE.getDesc())){
                return MaterialEnum.TITLE.getCode();
            }
            if(StringUtils.isNoneBlank(desc) && desc.equals(MaterialEnum.BRAND.getDesc())){
                return MaterialEnum.BRAND.getCode();
            }
            if(StringUtils.isNoneBlank(desc) && desc.equals(MaterialEnum.DESC.getDesc())){
                return MaterialEnum.TITLE.getCode();
            }
        }
        return MaterialEnum.IMAGE.getCode();

    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
