package cn.com.duiba.tuia.adx.center.api.dto;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2021/10/26
 * @Description
 * @Param
 * @return
 **/
@Data
public class AdxMaterialUnitDataDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 分成比例（含增值）
     * 公式：
     * 媒体消耗/广告消耗*1.15
     * adx_consume/consume_total*1.15
     */
    private Double adxDividePercent;
    /**
     * roi
     * 公式：
     * 广告消耗/媒体消耗
     * consume_total/adx_consume
     */
    private Double adxRoi;
    /**
     *暂时不返回
     */
    private Double adxBidReturnRate;
    /**
     *竞价成功率
     * 竞价成功数量/返回数量
     * bidding_success_pv/ bidding_return_pv
     */
    private Double adxBidSuccessRate;
    /**
     *千次曝光成本
     * 111日志中的该创意素材扣费平均值
     * adx_consume / adx_exposure_pv
     */
    private Double adxExposureCost;
    /**
     *暂时不返回
     */
    private Double adxClickRate;
    /**
     *暂时不返回
     */
    private Double adxClickCost;
    /**
     *活动参与率（UV）
     * 活动参与数量(uv)/广告位访问数量(uv)
     * act_join_uv / slot_request_uv
     */
    private Double activityUvJoinRate;
    /**
     *广告券点击率（UV）
     * 券点击/发券
     * click_pv / launch_pv
     */
    private Double couponClickRate;
    /**
     *每PV消耗
     *券消耗/活动访问pv
     * consume_total / act_request_pv
     */
    private Double activityRequestConsume;
    /**
     *每UV消耗
     * 券消耗/活动访问uv
     * consume_total / act_request_uv
     */
    private Double activityRequestUvConsume;
    /**
     *落地页到达率
     * 广告落地页曝光pv/广告券点击pv
     * form_visit /  click_pv
     */
    private Double lpAccessRate;
    /**
     *落地页转化率
     *广告落地页转化pv/广告落地页曝光pv
     * form_effect / form_visit
     */
    private Double lpEffectRate;
    /**
     *活动参与率（PV）
     *
     * 活动参与数量(pv)/广告位访问数量(pv)
     * act_join_pv / slot_request_pv
     */
    private Double activityPvJoinRate;
    /**
     * adx消耗
     */
    private Double adxConsume;
    /**
     * 广告消耗
     */
    private Long  consumeTotal;
    /**
     * adx竞价请求数
     */
    private Long biddingRequestPv;
    /**
     * adx最终参与竞价
     */
    private Long biddingFinalPv;
    /**
     * 复参数
     * act_join_pv/act_request_uv
     */
    private Double activityJoinRate;


    private Long id;
    private String unitName;
    private String unitDesc;
    private Integer unitType;
    private String materialJson;
    private Integer unitStatus;
    private Integer isDeleted;
    private String unitSize;
    private Integer rateType;
    private Integer styleType;
    private Integer isDirectIdea;
    private Long directIdeaId;
    private Date gmtCreate;
    private Date gmtModified;
    private Long adStyleId;
    private String templateId;
    private Long materialLibId;

    private List<MaterialDetailDto> materialDetailDtoList;

    /**
     * 1:待审核 2:审核通过 3:审核拒绝
     */
    private Integer auditStatus;

    /**
     * 送审ID
     */
    private String submitId;

    /**
     * 审核ID
     */
    private String auditId;

    /**
     * 素材类型 0-人工素材 1-算法素材
     */
    private Integer materialType;

    /**
     * 综合效率
     */
    private BigDecimal crste;

    /**
     *adx点击
     */
    private Long adxClickPv;

    /**
     *adx曝光pv
     */
    private Long adxExposurePv;

    public void buildMaterialDetail() {
        if (StringUtils.isBlank(materialJson)) {
            return;
        }
        this.setMaterialDetailDtoList(JSONObject.parseArray(materialJson, MaterialDetailDto.class));
    }

}
