/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.adx.center.api.dto;

import cn.com.duiba.tuia.adx.center.api.enums.TuiaStyleTypeEnum;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * 描述: 创意素材
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/4/19 11:37
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MaterialUnitFilterCondition implements Serializable {
    private static final long serialVersionUID = 9081345423518807603L;

    /**
     * 推啊内部样式-简易版
     */
    private TuiaStyleTypeEnum tuiaStyleTypeEnum;

    /**
     * 创意素材标题过滤条件
     */
    private MaterialUnitTitleFilter materialUnitTitleFilter;

    /**
     * 创意素材描述过滤条件
     */
    private MaterialUnitDescFilter materialUnitDescFilter;

    /**
     * 素材过滤条件
     */
    private List<MaterialUnitDetailFilter> materialUnitDetailFilterList;

    public MaterialUnitFilterCondition(TuiaStyleTypeEnum tuiaStyleTypeEnum) {
        this.tuiaStyleTypeEnum = tuiaStyleTypeEnum;
    }

    public MaterialUnitFilterCondition(MaterialUnitTitleFilter titleFilter,
                                       MaterialUnitDescFilter descFilter,
                                       List<MaterialUnitDetailFilter> detailFilterList) {
        this.materialUnitTitleFilter = titleFilter;
        this.materialUnitDescFilter = descFilter;
        this.materialUnitDetailFilterList = detailFilterList;
    }


    public MaterialUnitFilterCondition setCommonStyle(TuiaStyleTypeEnum styleTypeEnum) {
        this.tuiaStyleTypeEnum = styleTypeEnum;
        return this;
    }

    /**
     * 根据推啊样式明细，获取推啊样式类型枚举
     *
     * @return
     */
    public static MaterialUnitFilterCondition transfer(AdvertisingSpaceStyleDetailDto adStyleDto,
                                                       List<AdvertisingSpaceStyleMaterialDto> adStyleMaterialList) {
        if (adStyleDto == null || CollectionUtils.isEmpty(adStyleMaterialList)) {
            return new MaterialUnitFilterCondition(TuiaStyleTypeEnum.UNKNOWN);
        }
        Integer size = adStyleDto.getNum();
        MaterialUnitTitleFilter titleFilter = BeanUtils.copy(adStyleDto, MaterialUnitTitleFilter.class);
        MaterialUnitDescFilter descFilter = BeanUtils.copy(adStyleDto, MaterialUnitDescFilter.class);
        List<MaterialUnitDetailFilter> detailFilterList = Lists.newArrayList();
        adStyleMaterialList.forEach(adStyleMaterialDto -> {
            MaterialUnitDetailFilter detailFilter = BeanUtils.copy(adStyleMaterialDto, MaterialUnitDetailFilter.class);
            detailFilter.setMaterialType(adStyleMaterialDto.getType());
            detailFilter.setSize(Objects.equals(adStyleMaterialDto.getUnit(), "KB") ? adStyleMaterialDto.getSize() : adStyleMaterialDto.getSize() * 1024L);
            detailFilterList.add(detailFilter);
        });
        MaterialUnitFilterCondition materialUnitFilter = new MaterialUnitFilterCondition(titleFilter, descFilter, detailFilterList);
        TuiaStyleTypeEnum styleTypeEnum = TuiaStyleTypeEnum.UNKNOWN;
        switch (size) {
            case 1:
                styleTypeEnum = Objects.equals(adStyleMaterialList.get(0).getType(), 1) ?
                        TuiaStyleTypeEnum.ONE_IMAGE : TuiaStyleTypeEnum.VIDEO;
                return materialUnitFilter.setCommonStyle(styleTypeEnum);
            case 2:
                styleTypeEnum = TuiaStyleTypeEnum.VIDEO;
                if (Objects.equals(adStyleMaterialList.get(0).getType(), 1) &&
                        Objects.equals(adStyleMaterialList.get(1).getType(), 1)) {
                    styleTypeEnum = TuiaStyleTypeEnum.TWO_IMAGE;
                }
                return materialUnitFilter.setCommonStyle(styleTypeEnum);
            case 3:
                styleTypeEnum = TuiaStyleTypeEnum.UNKNOWN;
                if (Objects.equals(adStyleMaterialList.get(0).getType(), 1) &&
                        Objects.equals(adStyleMaterialList.get(1).getType(), 1) &&
                        Objects.equals(adStyleMaterialList.get(2).getType(), 1)) {
                    styleTypeEnum = TuiaStyleTypeEnum.THREE_IMAGE;
                }
                return materialUnitFilter.setCommonStyle(styleTypeEnum);
            default:
                return materialUnitFilter.setCommonStyle(styleTypeEnum);
        }
    }

}
