package cn.com.duiba.tuia.adx.center.api.enums;

import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: 创意出价方式
 *
 * @author hillchen
 * @create 2019/2/24 14:38
 */
public enum PriceType {

    /**
     *
     */
    MANUAL(0, "互动人工出价"),

    ALGORITHM(1, "互动算法出价"),

    DIRECTLY_ALGORITHM(2, "直投算法出价"),

    DIRECTLY_MANUAL(3, "直投人工出价");

    private int type;
    private String desc;

    PriceType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isSameType(Integer type) {
        return type != null && Objects.equals(type, this.type);
    }

    /**
     * 判断出价策略是否是算法的一种
     *
     * @param type
     * @return
     */
    public static boolean isAlgorithm(Integer type) {
        return type != null &&
                (Objects.equals(PriceType.ALGORITHM.getType(), type) ||
                        Objects.equals(PriceType.DIRECTLY_ALGORITHM.getType(), type));
    }

    public static boolean hasPriceType(Integer type) {
        if (type != null) {
            for (PriceType priceType : PriceType.values()) {
                if (priceType.isSameType(type)) {
                    return true;
                }
            }
        }
        return false;
    }
}
