package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.common.PageDto;
import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaCombDTO;
import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.adx.center.api.req.ResourceIdeaBatchPriceDTO;
import cn.com.duiba.tuia.adx.center.api.req.ResourceIdeaPageReq;
import cn.com.duiba.tuia.adx.center.api.req.ResourceIdeaQueryReq;

import java.util.List;

/**
 * 创意服务
 *
 * @author weny.cai
 * @date 2018/12/3 14:26
 **/
@AdvancedFeignClient
public interface RemoteResourceIdeaService {

    boolean addV4(ResourceIdeaCombDTO dto) throws BizException;

    /**
     * 批量添加创意素材
     * @param combDTOS
     * @return
     * @throws BizException
     */
    Boolean batchUploadMaterials(List<ResourceIdeaCombDTO> combDTOS) throws BizException;

    boolean updateV4(ResourceIdeaCombDTO dto) throws BizException;

    String batchUpdateV4(List<ResourceIdeaCombDTO> resourceIdeaCombDTOList);

    PageDto<ResourceIdeaDto> pageQuery(ResourceIdeaPageReq req);

    List<ResourceIdeaDto> queryListByResourceId(Long resourceId);

    List<ResourceIdeaDto> queryListByResourceIdAndPmpType(Long resourceId, Integer pmpType);

    ResourceIdeaDto getIdeaById(Long id);

    boolean changeSwitchStateById(Long id, Integer switchState);

    String batchChangeSwitchState(List<Long> idList, Integer switchState);

    void deleteById(Long id) throws BizException;

    String batchDelete(List<Long> idList);

    /**
     * 获取adx广告位id
     *
     * @return
     */
    List<Long> selelctAdxSlotIds();

    /**
     * 根据switchStatus查询创意
     *
     * @param switchStatus switchStatus
     * @return list
     */
    List<ResourceIdeaDto> queryAllIdeaBySwitchStatus(Integer switchStatus);

    /**
     * 根据条件查询创意集合
     *
     * @param req
     * @return
     */
    List<Long> selectIds(ResourceIdeaPageReq req);

    /**
     * 根据创意ID查询创意详情（不会关联其他表数据）
     *
     * @param ideaId
     * @return
     */
    ResourceIdeaDto queryIdeaById(Long ideaId);

    /**
     * 根据创意Id查询创意(组合返回图片和推广组信息)
     * @param ideaId
     * @return
     */
    ResourceIdeaDto getIdeaWithPictureAndGroup(Long ideaId);

    /**
     * 查询可用的算法出价的创意
     *
     * @return list
     */
    List<ResourceIdeaDto> queryAlgoIdeaBySwitchStatus();

    @Deprecated
    List<ResourceIdeaDto> getAlgIdeaBySwitchStatus();

    /**
     * 查询可用的算法出价的创意
     *
     * @return list
     */
    List<ResourceIdeaDto> queryAlgoIdeaBySwitchStatusV4();

    /**
     * 查询可用的PD创意
     *
     * @return list
     */
    List<ResourceIdeaDto> queryPdIdeaBySwitchStatus();

    /**
     * 功能描述 根据广告位样式ID集合查询资源创意是否存在
     * @author shenjiaqing
     * @date 11:36 2019/11/20
     * @param [adStyleIdList]
     * @return java.lang.Integer
     **/
    Integer resourceIdeaIsExistsByAdStyleId(List<Long> adStyleIdList);

    /**
     * @Description  查询所有直投广告位ID
     * @Date 19:59 2020-04-10
     * @Param []
     * @return java.util.List<java.lang.Long>
     **/
    List<Long> getAllDirectSlotIds();

    List<ResourceIdeaDto> queryIdeaList(ResourceIdeaQueryReq req);

    PageDto<ResourceIdeaDto> specificSortPageQuery(ResourceIdeaPageReq req);

    List<ResourceIdeaDto> queryIdeaListByIdeaIds(List<Long> ideaIds);

    List<ResourceIdeaDto> getValidIdeas(ResourceIdeaQueryReq req);

    List<ResourceIdeaDto> selectIdeaListByDeliveryManageSwitch(Long resourceLocationId, Integer deliveryManageSwitch);

    /**
     * 通过id更新创意名称
     * @param id
     * @param ideaName
     * @param ideNameWildcard
     * @return
     */
    Boolean modifyIdeaNameById(Long id, String ideaName, String ideNameWildcard);

    /**
     * 批量修改创意计划价格
     * @param dto
     * @return
     * @throws BizException
     */
    boolean batchEditPrice(ResourceIdeaBatchPriceDTO dto);

    /**
     * 更新机型
     * @param id 创意id
     * @param phoneModel 机型
     * @return
     */
    Boolean updatePhoneModel(Long id, String phoneModel);

}
