package cn.com.duiba.tuia.adx.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@ApiModel
public class CrowdBindDTO implements Serializable {

    @ApiModelProperty(value = "绑定Id", required = false)
    private Long bindId;

    @ApiModelProperty(value = "绑定对象类型", required = true)
    @NotNull
    private Integer objectType;

    @ApiModelProperty(value = "绑定对象ID", required = true)
    @NotNull
    private Long objectId;

    @ApiModelProperty(value = "绑定方式", required = true)
    @NotNull
    private Integer bindType;

    @ApiModelProperty(value = "绑定时间", required = true)
    @NotNull
    private Date bindTime;

    private List<CrowdBindExtraDTO> extraInfo;

    public Long getBindId() {
        return bindId;
    }

    public void setBindId(Long bindId) {
        this.bindId = bindId;
    }

    public Integer getObjectType() {
        return objectType;
    }

    public void setObjectType(Integer objectType) {
        this.objectType = objectType;
    }

    public Long getObjectId() {
        return objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public Integer getBindType() {
        return bindType;
    }

    public void setBindType(Integer bindType) {
        this.bindType = bindType;
    }

    public Date getBindTime() {
        return bindTime;
    }

    public void setBindTime(Date bindTime) {
        this.bindTime = bindTime;
    }

    public List<CrowdBindExtraDTO> getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(List<CrowdBindExtraDTO> extraInfo) {
        this.extraInfo = extraInfo;
    }

    @Override
    public String toString() {
        return "CrowdBindDTO{" +
                "bindId=" + bindId +
                ", objectType=" + objectType +
                ", objectId=" + objectId +
                ", bindType=" + bindType +
                ", bindTime=" + bindTime +
                ", extraInfo=" + extraInfo +
                '}';
    }
}
