package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.common.PageDto;
import cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceTypeDto;
import cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceTypeInsertDto;
import cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceTypeUpdateDto;
import cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceTypesDto;
import cn.com.duiba.tuia.adx.center.api.req.AdTypePageReq;

import java.util.List;

/**
 * @author shenjiaqing
 * @description 广告位类型功能开发
 * @data 2019/11/18
 */
@AdvancedFeignClient
public interface RemoteAdvertisingSpaceTypeService {

    /**
     * 功能描述 根据Adx平台类型获取广告位类型列表
     *
     * @return java.util.List<cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceTypesDto>
     * @author shenjiaqing
     * @date 13:39 2019/11/19
     **/
    List<AdvertisingSpaceTypesDto> getAllByAdxType(Integer adxType);

    /**
     * 功能描述 检查广告位类型名称的唯一性
     *
     * @return java.lang.Integer
     * @author shenjiaqing
     * @date 13:38 2019/11/19
     **/
    boolean typeNameIsExists(String typeName, Long id, Integer adxType);

    /**
     * 功能描述 检查Adx对应广告位类型Id的唯一性
     *
     * @return java.lang.Integer
     * @author shenjiaqing
     * @date 17:33 2019/11/20
     **/
    boolean templateIdIsExists(String templateId, Long id, Integer adxType);

    /**
     * 功能描述 添加广告位类型
     *
     * @return java.lang.Integer
     * @author shenjiaqing
     * @date 13:39 2019/11/19
     **/
    boolean insert(AdvertisingSpaceTypeInsertDto dto);

    /**
     * 添加广告位类型 并返回id
     */
    Long insertAndGetId(AdvertisingSpaceTypeInsertDto dto);

    /**
     * 功能描述 编辑广告位类型
     *
     * @return java.lang.Integer
     * @author shenjiaqing
     * @date 13:39 2019/11/19
     **/
    boolean update(AdvertisingSpaceTypeUpdateDto dto);

    /**
     * 功能描述 根据广告位类型ID获取广告位详情
     *
     * @return cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceTypeDto
     * @author shenjiaqing
     * @date 13:39 2019/11/19
     **/
    AdvertisingSpaceTypeDto getAdSpaceTypeById(Long id);

    /**
     * 功能描述 删除广告位类型
     *
     * @return java.lang.Integer
     * @author shenjiaqing
     * @date 13:44 2019/11/19
     **/
    boolean delete(Long id, boolean isDeleteStyle);

    /**
     * 功能描述 根据广告位类型ID获取广告位ID
     *
     * @return java.lang.String
     * @author shenjiaqing
     * @date 14:36 2019/11/19
     **/
    String getAdPositionIdByAdTypeId(Long id);

    /**
     * 功能描述 根据adxType查询广告位类型
     *
     * @return java.util.List<cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceTypesDto>
     * @author shenjiaqing
     * @date 9:46 2019/11/21
     **/
    List<AdvertisingSpaceTypesDto> getTypeNameByAdxType(Integer adxType);

    /**
     * 功能描述 根据adxTypeList查询广告位类型列表
     *
     * @param adxTypeList
     * @return java.util.List<cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceTypesDto>
     * @author shenjiaqing
     * @date 9:46 2019/11/21
     **/
    List<AdvertisingSpaceTypesDto> getTypeNameByAdxTypeList(List<Integer> adxTypeList);

    /**
     * 功能描述 查看此广告位是否存在
     *
     * @return boolean
     * @author shenjiaqing
     * @date 10:29 2019/11/25
     **/
    boolean adTypeIsExists(Long id);

    /**
     * 功能描述 查询指定推广组下的所有广告位类型的ADX广告位ID
     * @author shenjiaqing
     * @date 12:23 2019/12/5
     * @return cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceTypesDto
     **/
    List<AdvertisingSpaceTypesDto> getAllAdPositionIdByAdxType(Integer adxType, Long id);

    /**
     * 分页查询广告位类型
     */
    PageDto<AdvertisingSpaceTypesDto> typePageQuery(AdTypePageReq adTypePageReq);


}
