package cn.com.duiba.tuia.adx.center.api.dto.tuia.adx.response;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Created by hong
 * time 2023/11/6.
 */
@Data
public class TuiaAdxBidResponse implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 请求id
     */
    private String requestId;

    /**
     * 推啊提供给Dsp的id
     */
    private Long dspId;

    /**
     * 推啊提供的广告主id
     */
    private String advertiserId;

    /**
     * 出价 单位:千次曝光分
     */
    private Integer price;

    /**
     * cpc出价 单位：分
     */
    private Integer cpcPrice;

    /**
     * 计费类型 目前只支持CPM
     * 0:CPM
     * 1:CPC
     */
    private Integer chargeType;

    /**
     * 创意id
     */
    private Long creativeId;

    /**
     * 素材id
     */
    private Long materialId;

    /**
     * 落地页地址
     */
    private String landingPageUrl;

    /**
     * 标题
     */
    private String title;

    /**
     * 描述
     */
    private String desc;

    /**
     * iconUrl
     */
    private String iconUrl;

    /**
     * 请求宽
     */
    private Integer width;

    /**
     * 请求高
     */
    private Integer height;

    /**
     * 图片素材信息
     */
    private TuiaAdxImageInfo imageInfo;

    /**
     * 视频素材信息
     */
    private TuiaAdxVideoInfo videoInfo;

    /**
     * 下载五要素下载广告必填
     */
    private TuiaAdxAppDownload appDownloadInfo;

    /**
     * deepLink
     */
    private String deepLink;

    /**
     * 胜出监测地址
     */
    private List<String> winUrls;

    /**
     * 曝光监测地址(支持宏替换)
     */
    private List<String> exposureUrls;

    /**
     * 点击监测地址
     */
    private List<String> clickUrls;
}
