package cn.com.duiba.tuia.adx.center.api.enums;

import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: adx日志类型
 *
 * @author hillchen
 * @create 2019/2/28 17:32
 */
public enum AdxLogType {

    BID_WAKE(6, "唤醒"),
    BID_REAL_RET(5, "真实返回"),
    BID_REQ(4,"竞价请求"),
    BID_RET(3,"竞价返回"),
    BID_SUC(2,"竞价成功"),
    BID_CLI(1,"资源位点击"),
    BID_EXP(0,"资源位曝光")
    ;
    private int type;
    private String desc;

    AdxLogType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isSameType(Integer adxLogType){
        return Objects.nonNull(adxLogType) && Objects.equals(type,adxLogType);
    }
}
