package cn.com.duiba.tuia.adx.center.api.enums;

import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: 创意出价方式
 *
 * @author hillchen
 * @create 2019/2/24 14:38
 */
public enum PriceType {

    //CPM出价 OCPM也是CPM出价
    CPM(0, "CPM"),

    CPM_PLUS(1, "基于底价"),

    BD_CPC(2, "百度CPC"),

    BD_OCPM(3, "百度OCPM");

    private int type;
    private String desc;

    PriceType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isSameType(Integer type) {
        return type != null && Objects.equals(type, this.type);
    }

    public static boolean hasPriceType(Integer type) {
        if (type != null) {
            for (PriceType priceType : PriceType.values()) {
                if (priceType.isSameType(type)) {
                    return true;
                }
            }
        }
        return false;
    }
}
