/**
 * Project Name:tuia-core-api<br>
 * File Name:AdvertMaterialDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年12月21日下午2:11:03<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.adx.center.api.dto;

import cn.com.tuia.advert.model.MaterialVideoExt;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

/**
 * 广告素材DTO <br/>
 * date: 2016年12月21日 下午2:11:03 <br/>
 * .
 *
 * @author youhaijun
 * @version
 * @since JDK 1.7
 */
public class AdvertMaterialDto extends BaseDto {

    /** The Constant serialVersionUID. @since JDK 1.7 */
    private static final long  serialVersionUID   = -3596705396272567507L;

    /** 默认按钮文案. */
    public static final String DEFAULT_BTN_TEXT   = "马上使用";

    /** 默认素材. */
    public static final int    IS_DEFAULT         = 1;

    /** 非默认素材. */
    public static final int    IS_NOT_DEFAULT     = 0;

    /** 激活. */
    public static final int    IS_ACTIVE          = 1;

    /** 屏蔽. */
    public static final int    IS_NOT_ACTIVE      = 0;

    /** 删除状态. */
    public static final int    IS_DELETE          = 1;

    /** 非删除态. */
    public static final int    IS_NOT_DELETE      = 0;

    /** 素材曾激活. */
    public static final int    EVER_ACTIVATED     = 1;

    /** 素材未曾激活. */
    public static final int    EVER_NOT_ACTIVATED = 0;
    /** 提交审核. */
    public static final int    AUDIT_COMMIT = 2;
    /** 审核通过. */
    public static final int    AUDIT_PASS = 0;
    /** 审核拒绝. */
    public static final int    AUDIT_REFUSE = 3;
    /** 新增.*/
    public static final int    AUDIT_NEW = 1;
    /** ADX直投进审失败 */
    public static final int    AUDIT_ADX_DIRECT_FAILED = 4;
    /** 兑吧已审. */
    public static final int    DUIBA_AUDIT = 1;
    /** 兑吧未审.*/
    public static final int    DUIBA_NOT_AUDIT = 0;
    /** 兑吧审核，标记推啊已审.*/
    public static final int    DUIBA_AUDIT_TUIA_AUDIT = -1;

    /** 素材审核中 人为屏蔽/激活 素材状态*/
    public static final Integer IS_MANUAL = 1;

    public static final Integer IS_NOT_MANUAL = 0;

    /** 互动广告普通素材 newMaterialType */
    public static final Integer COMMON_MATERIAL = 0;

    /** 互动广告特殊素材 newMaterialType */
    public static final Integer SPECIAL_MATERIAL = 1;

    /** 互动广告特ADX直投素材 newMaterialType */
    public static final Integer NEW_MATERIAL_TYPE_ADX_DIRECT = 2;

    /** 互动广告视频素材*/
    public static final Integer NEW_MATERIAL_TYPE_VIDEO = 3;


    /** 广告ID. */
    private Long               advertId;

    /** 默认状态(0：非默认素材， 1：默认素材). */
    private Integer            isDefault;

    /** 激活状态(0：屏蔽， 1：激活). */
    private Integer            isActive;

    /** 审核状态. */
    private Integer            checkStatus;

    /** 商品名称. */
    private String             couponName;

    /** 素材名称. */
    private String             materialName;

    /** 详情页banner图. */
    private String             bannerPng;

    /** 按钮文案. */
    private String             buttonText;

    /** 一句话描述. */
    private String             description;

    /** 素材媒体白名单列表(媒体ID以英文逗号隔开). */
    private String             whiteList;

    /** 素材媒体黑名单列表(媒体ID以英文逗号隔开). */
    private String             blackList;

    /** 删除状态(0：未删除， 1：已删除). */
    private Integer            isDeleted;

    /** 素材是否曾激活（0：未被激活过，1：曾激活过） *. */
    private Integer            everActivated;

    /** 兑吧审核状态 ：0-未审核；1-已审核 */
    private Integer            duibaCheckStatus;

    /**
     * 素材设计师
     */
    private String designer;

    private String productName;

    /** 动态商品名称的值 */
    private String productNameValue;

    private Integer productNameTag;

    private Integer hiddenStatus;

    /**
     * 素材信息关联表（tb_material_photo_info）id
     */
    private Long photoId;

    /**
     * 试投素材第一次审批通过时间
     * @return
     */
    private Date auditPassTime;

    //素材类型
    private Integer materialType;

    /**
     * 素材审核记录数量
     */
    private Integer checkRecord;

    // 弹层id,给素材审核-弹层ID显示用的
    private Long windId;

    /**激励金额*/
    private Long encourageFee;

    /**素材类型*/
    private Integer newMaterialType;

    public Long getWindId() {
        return windId;
    }

    public void setWindId(Long windId) {
        this.windId = windId;
    }

    public Integer getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }

    public Integer getHiddenStatus() {
        return hiddenStatus;
    }

    public void setHiddenStatus(Integer hiddenStatus) {
        this.hiddenStatus = hiddenStatus;
    }

    /**
     * 原默认素材id
     * @return
     */
    private Long parentMaterialId;

    private String auditor;

    private Date auditTime;

    private Integer isManual;

    /** 进审时间 */
    private Date enterCheckTime;

    /** 视频格式*/
    private Integer format;
    /** 视屏封面图*/
    private String videoCoverUrl;
    /** 视频完播图*/
    private String videoCompletionUrl;
    /** 视频时长*/
    private Integer videoDuration;
    /** 视频交互样式活动ID*/
    private Long videoActivityId;
    /** 视频完播图竖版*/
    private String videoCompletionUrlVertical;
    /** 视频完播图方向 0:横版 1:竖版*/
    private Integer videoCompletionDirection;
    /** 底部card*/
    private String videoCardUrl;
    /** 视频扩展 */
    private String videoExt;
    /** 视频扩展信息 */
    private MaterialVideoExt videoExtInfo;

    /** 素材关键词命中标签 */
    private String materialHitTag;

    public Long getParentMaterialId() {
        return parentMaterialId;
    }

    public void setParentMaterialId(Long parentMaterialId) {
        this.parentMaterialId = parentMaterialId;
    }

    public Date getAuditPassTime() {
        return auditPassTime;
    }

    public void setAuditPassTime(Date auditPassTime) {
        this.auditPassTime = auditPassTime;
    }

    public Long getPhotoId() {
        return photoId;
    }

    public void setPhotoId(Long photoId) {
        this.photoId = photoId;
    }

    /**
     * duibaCheckStatus.
     *
     * @return  the duibaCheckStatus
     * @since   JDK 1.8
     */
    public Integer getDuibaCheckStatus() {
        return duibaCheckStatus;
    }

    /**
     * duibaCheckStatus.
     *
     * @param   duibaCheckStatus    the duibaCheckStatus to set
     * @since   JDK 1.8
     */
    public void setDuibaCheckStatus(Integer duibaCheckStatus) {
        this.duibaCheckStatus = duibaCheckStatus;
    }

    /**
     * materialName.
     *
     * @return the materialName
     * @since JDK 1.7
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * materialName.
     *
     * @param materialName the materialName to set
     * @since JDK 1.7
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    /**
     * Gets the advert id.
     *
     * @return the advert id
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * Sets the advert id.
     *
     * @param advertId the advert id
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the is deffault.
     *
     * @return the checks if is deffault
     */
    public Integer getIsDefault() {
        return isDefault;
    }

    /**
     * Sets the is deffault.
     *
     * @param isDefault the checks if is deffault
     */
    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    /**
     * Gets the is shield.
     *
     * @return the checks if is shield
     */
    public Integer getIsActive() {
        return isActive;
    }

    /**
     * Sets the is shield.
     *
     * @param isActive the checks if is active
     */
    public void setIsActive(Integer isActive) {
        this.isActive = isActive;
    }

    /**
     * Gets the coupon name.
     *
     * @return the coupon name
     */
    public String getCouponName() {
        return couponName;
    }

    /**
     * Sets the coupon name.
     *
     * @param couponName the coupon name
     */
    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    /**
     * Gets the banner png.
     *
     * @return the banner png
     */
    public String getBannerPng() {
        return bannerPng;
    }

    /**
     * Sets the banner png.
     *
     * @param bannerPng the banner png
     */
    public void setBannerPng(String bannerPng) {
        this.bannerPng = bannerPng;
    }

    /**
     * Gets the button text.
     *
     * @return the button text
     */
    public String getButtonText() {
        return buttonText;
    }

    /**
     * Sets the button text.
     *
     * @param buttonText the button text
     */
    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    /**
     * Gets the content.
     *
     * @return the content
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the content.
     *
     * @param description the description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Gets the is deleted.
     *
     * @return the checks if is deleted
     */
    public Integer getIsDeleted() {
        return isDeleted;
    }

    /**
     * Sets the is deleted.
     *
     * @param isDeleted the checks if is deleted
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    /**
     * Gets the white list.
     *
     * @return the white list
     */
    public String getWhiteList() {
        return whiteList;
    }

    /**
     * Sets the white list.
     *
     * @param whiteList the white list
     */
    public void setWhiteList(String whiteList) {
        this.whiteList = whiteList;
    }

    /**
     * Gets the black list.
     *
     * @return the black list
     */
    public String getBlackList() {
        return blackList;
    }

    /**
     * Sets the black list.
     *
     * @param blackList the black list
     */
    public void setBlackList(String blackList) {
        this.blackList = blackList;
    }

    /**
     * Gets the ever activated.
     *
     * @return the ever activated
     */
    public Integer getEverActivated() {
        return everActivated;
    }

    /**
     * Sets the ever activated.
     *
     * @param everActivated the ever activated
     */
    public void setEverActivated(Integer everActivated) {
        this.everActivated = everActivated;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductNameValue() {
        return productNameValue;
    }

    public void setProductNameValue(String productNameValue) {
        this.productNameValue = productNameValue;
    }

    public String getAuditor() {
        return auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Integer getProductNameTag() {
        return productNameTag;
    }

    public void setProductNameTag(Integer productNameTag) {
        this.productNameTag = productNameTag;
    }

    public Integer getIsManual() {
        return isManual;
    }

    public void setIsManual(Integer isManual) {
        this.isManual = isManual;
    }

    public Integer getCheckRecord() {
        return checkRecord;
    }

    public void setCheckRecord(Integer checkRecord) {
        this.checkRecord = checkRecord;
    }

    public Long getEncourageFee() {
        return encourageFee;
    }

    public void setEncourageFee(Long encourageFee) {
        this.encourageFee = encourageFee;
    }

    public Integer getNewMaterialType() {
        return newMaterialType;
    }

    public void setNewMaterialType(Integer newMaterialType) {
        this.newMaterialType = newMaterialType;
    }

    public Date getEnterCheckTime() {
        return enterCheckTime;
    }

    public void setEnterCheckTime(Date enterCheckTime) {
        this.enterCheckTime = enterCheckTime;
    }

    public Integer getFormat() {
        return format;
    }

    public void setFormat(Integer format) {
        this.format = format;
    }

    public String getVideoCoverUrl() {
        return videoCoverUrl;
    }

    public void setVideoCoverUrl(String videoCoverUrl) {
        this.videoCoverUrl = videoCoverUrl;
    }

    public String getVideoCompletionUrl() {
        return videoCompletionUrl;
    }

    public void setVideoCompletionUrl(String videoCompletionUrl) {
        this.videoCompletionUrl = videoCompletionUrl;
    }

    public Integer getVideoDuration() {
        return videoDuration;
    }

    public void setVideoDuration(Integer videoDuration) {
        this.videoDuration = videoDuration;
    }

    public Long getVideoActivityId() {
        return videoActivityId;
    }

    public void setVideoActivityId(Long videoActivityId) {
        this.videoActivityId = videoActivityId;
    }

    public String getVideoCompletionUrlVertical() {
        return videoCompletionUrlVertical;
    }

    public void setVideoCompletionUrlVertical(String videoCompletionUrlVertical) {
        this.videoCompletionUrlVertical = videoCompletionUrlVertical;
    }

    public Integer getVideoCompletionDirection() {
        return videoCompletionDirection;
    }

    public void setVideoCompletionDirection(Integer videoCompletionDirection) {
        this.videoCompletionDirection = videoCompletionDirection;
    }

    public String getVideoCardUrl() {
        return videoCardUrl;
    }

    public void setVideoCardUrl(String videoCardUrl) {
        this.videoCardUrl = videoCardUrl;
    }

    public String getVideoExt() {
        return videoExt;
    }

    public void setVideoExt(String videoExt) {
        this.videoExt = videoExt;
    }

    public MaterialVideoExt getVideoExtInfo() {
        if (videoExtInfo == null && StringUtils.isNotBlank(videoExt)) {
            try {
                videoExtInfo = JSON.parseObject(videoExt, MaterialVideoExt.class);
            } catch (Exception e) {
                // ignore
            }
        }
        return videoExtInfo;
    }

    public void setVideoExtInfo(MaterialVideoExt videoExtInfo) {
        this.videoExtInfo = videoExtInfo;
    }

    public String getMaterialHitTag() {
        return materialHitTag;
    }

    public void setMaterialHitTag(String materialHitTag) {
        this.materialHitTag = materialHitTag;
    }
}
