package cn.com.duiba.tuia.adx.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 资源位
 *
 * @author weny.cai
 * @date 2018/11/30 10:51
 **/
@Data
public class ResourceLocationDto implements Serializable {

    private static final long serialVersionUID = 6379475736453923151L;
    private Long id;

    private List<Long> idList;

    private Long groupId;

    private String resourceName;

    private Integer switchState;

    private Integer budgetType;

    private Double dayBudget;

    private String dayBudgetStr;

    private List<String> posIds;

    private List<String> posIdList;

    private PopularGroupDto popularGroupDto;

    private Long exposurePv;

    private Long clickPv;

    private String price;

    private Double roi;

    private String clickRate;

    private String agvPrice;

    /** 第三方广告类型模版id **/
    private String templateId;

    /** 广告位类型ID **/
    private Long adTypeId;

    /** 广告位类型 **/
    private String adTypeName;

    private List<ResourceIdeaDto> deliveryManageResourceIdeas;

    /**
     * 推啊的广告位id
     */
    private Long slotId;

    /**
     * 资源位广告消耗
     */
    private BigDecimal income;
    /**
     * 弹窗开关 0-关闭 1-开启
     */
    private Integer popupSwitch;

    /**
     * 支付宝域名替换 0-关闭 1-开启
     */
    private Integer alipayUrlSwitch;
}
