/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.adx.center.api.enums;

import cn.com.duiba.tuia.adx.center.api.enums.AuditTypeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public enum AdxTypeEnum {
    LIEBAO(1, "\u730e\u8c79", "55287", "3", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    SOUGOU(2, "\u641c\u72d7", "56100", "10", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    MOJI(3, "\u58a8\u8ff9\u5929\u6c14", "57045", "11", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    BAOFENG(4, "\u66b4\u98ce\u5f71\u97f3", "58196", "18", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    BAIDU(5, "\u767e\u5ea6\u89c6\u9891", "82999", "156", true, AuditTypeEnum.AUDIT.getCode()),
    XIAOMI(6, "\u5c0f\u7c73", "58972", "21", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    ZHANG_YUE(7, "\u638c\u9605", "54876", "184", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    NAVIGATION(8, "2345", "63596", "42", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    LIAN_SHANG(9, "\u8fde\u5c1a", "64738", "59", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    XIAO_EN_AI(10, "\u5c0f\u6069\u7231", "63597", "71", false, AuditTypeEnum.AUDIT.getCode()),
    OPPO(11, "OPPO", "66506", "84", false, AuditTypeEnum.AUDIT.getCode()),
    I_QI_YI(12, "\u7231\u5947\u827a-\u8054\u76df", "79712", "96", true, AuditTypeEnum.AUDIT.getCode()),
    MEIZU(13, "\u9b45\u65cf", "68016", "94", false, AuditTypeEnum.AUDIT.getCode()),
    MONGO_TV(14, "\u8292\u679cTV", "69972", "124", false, AuditTypeEnum.AUDIT.getCode()),
    APUS(15, "APUS", "69989", "115", false, AuditTypeEnum.AUDIT.getCode()),
    MEI_SHU(16, "\u7f8e\u6570", "69822", "118", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    LENOVO(17, "\u8054\u60f3", "70379", "125", false, AuditTypeEnum.AUDIT.getCode()),
    MOMO(18, "\u964c\u964c", "70391", "119", false, AuditTypeEnum.AUDIT.getCode()),
    BAIDU_ALLIANCE(19, "\u767e\u5ea6\u8054\u76df", "71092", "129", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    IWANVI(20, "\u4e2d\u6587\u4e07\u7ef4", "71189", "130", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    MOMO_OPEN_SCREEN(21, "\u964c\u964c\u5f00\u5c4f", "71941", "134", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    QINGTING(22, "\u873b\u8713", "73007", "136", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    JD_FINANCE(23, "\u4eac\u4e1c\u91d1\u878d", "54751", "135", false, AuditTypeEnum.AUDIT.getCode()),
    QUTOUTIAO(24, "\u8da3\u5934\u6761-\u5176\u4ed6\u7cfb\u5217", "83064", "155", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    RUAN_GAO(25, "\u8f6f\u544a", "75699", "139", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    XIAN_JIAN(26, "\u5148\u8350", "75695", "141", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    SOHU(27, "\u641c\u72d0", "76366", "140", true, AuditTypeEnum.AUDIT.getCode()),
    QINGTING_2(28, "\u873b\u87132.0", "73007", "143", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    SIGMOB(29, "sigmob", "77448", "144", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    I_QI_YI_MAIN(30, "\u7231\u5947\u827a-\u4e3b\u7ad9", "68040", "151", true, AuditTypeEnum.AUDIT.getCode()),
    MONGO_PDB(31, "\u8292\u679cPDB", "61642", "152", false, AuditTypeEnum.AUDIT.getCode()),
    I_FLY_TEK(32, "IFlyTek", "82110", "153", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    INMOBI(33, "inmobi", "82147", "154", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    QUTOUTIAO_NOVEL(34, "\u8da3\u5934\u6761-\u5c0f\u8bf4\u7cfb\u5217", "82701", "157", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    FANCY(35, "\u6cdb\u4e3a", "83844", "158", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    KUAI_SHOU(36, "\u5feb\u624b\u8054\u76df", "84766", "159", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    XIMALAYA(37, "\u559c\u9a6c\u62c9\u96c5", "85431", "165", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    QQ_READ(38, "QQ\u9605\u8bfb", "80611", "169", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    HUAWEI_ALLIANCE(39, "\u534e\u4e3a\u8054\u76df", "86153", "170", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    YOUKU(40, "\u4f18\u9177", "83774", "171", false, AuditTypeEnum.AUDIT.getCode()),
    CHU_BAO(41, "\u89e6\u5b9d", "89596", "183", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    QB(42, "\u817e\u8bafQ\u7cfb", "89829", "185", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    X_MILES(43, "\u5c0f\u8fc8", "89876", "187", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    TUIA(44, "\u63a8\u554a", "86888", "189", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    YIDIANZIXUN(45, "\u4e00\u70b9\u8d44\u8baf", "86888", "227", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    MEITUAN(46, "\u7f8e\u56e2", "-1", "-1", false, AuditTypeEnum.AUDIT.getCode()),
    adscope(47, "adscope", "93845", "544", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    ubix(48, "ubix", "95090", "574", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    KUAISHOU_MASTER(49, "\u5feb\u624b\u5de8\u7f51", "96465", "574", false, AuditTypeEnum.AUDIT.getCode()),
    YUN_MA(50, "\u4e91\u7801", "0", "574", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    TUIA_ADX(51, "tuiaAdx", "0", "574", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    HUAWEI_ADX(52, "huaweiAdx", "86153", "574", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    ZHANG_YU(53, "\u7ae0\u9c7c", "96319", "574", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    JXEDT(54, "\u9a7e\u6821\u4e00\u70b9\u901a", "96782", "575", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    YDTX(55, "\u6613\u70b9\u5929\u4e0b", "96933", "576", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    ZHWNL(56, "\u4e2d\u534e\u4e07\u5e74\u5386", "97149", "577", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    WYY(57, "\u7f51\u6613\u4e91\u97f3\u4e50", "97179", "578", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    QIMAO(58, "\u4e03\u732b", "97130", "579", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    SYXJ(59, "\u6c34\u5370\u76f8\u673a", "97130", "580", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    TOPON(60, "TOPON", "97158", "653", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    LE_YOU_QI(61, "\u4e50\u4f18\u542f", "97500", "654", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    WU_BAI(62, "500\u7f51", "97606", "655", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    FEI_SUO(63, "\u98de\u68ad", "97538", "656", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    DE_JIAN(64, "\u5f97\u95f4", "97551", "657", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    B612(65, "B612", "97792", "658", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    BANTANG(66, "\u534a\u7cd6", "97880", "659", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    BAIXUN(67, "\u767e\u5bfb", "98001", "660", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    RUISHI(68, "\u745e\u72ee", "97934", "661", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    MAGIC(69, "magic", "97938", "662", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    HUICHUAN(70, "\u6c47\u5ddd", "0", "663", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    BOWANG(71, "\u535a\u671b", "98175", "664", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    HUYU(72, "\u4e92\u88d5", "98139", "665", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    FIREFLY(73, "\u8424\u706b\u866b", "98111", "666", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    KUAISHOU_MASTER2(74, "\u5feb\u624b\u5de8\u7f512", "96962", "667", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    DUOMENG(75, "\u591a\u76df", "98265", "668", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    YOUYOU(76, "\u4f18\u4f18", "98281", "669", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    ZUOYEBANG(77, "\u4f5c\u4e1a\u5e2e", "98282", "670", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    CHELAILE(78, "\u8f66\u6765\u4e86", "77210", "671", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    TUIA_MEDIA(79, "\u63a8\u554a\u5a92\u4f53", "77211", "672", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    Mediatom(80, "\u524d\u5448", "98700", "673", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    YHYL(81, "\u94f6\u6cb3\u5f15\u529b", "98718", "674", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    HAN_XIAO_QUAN(82, "\u97e9\u5c0f\u5708", "98740", "675", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    YUPAO(83, "\u9c7c\u6ce1", "98816", "676", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    DAYIMA(84, "\u5927\u59e8\u5988", "", "677", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    JUTUI(85, "\u805a\u63a8", "", "678", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    LEYOU_GAME(86, "\u638c\u4e0a\u4e50\u6e38", "", "679", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    SOUL(87, "Soul", "", "680", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    XUNLEI(88, "\u8fc5\u96f7", "", "680", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    CQWNL(89, "\u91cd\u5e86\u4e07\u5e74\u5386", "", "680", false, AuditTypeEnum.FREE_AUDIT.getCode());

    private Integer type;
    private String name;
    private String mediaId;
    private String groupId;
    private Boolean advertiserNeedAudit;
    private Integer auditType;

    private AdxTypeEnum(Integer type, String name, String mediaId, String groupId, Boolean advertiserNeedAudit, Integer auditType) {
        this.type = type;
        this.name = name;
        this.mediaId = mediaId;
        this.groupId = groupId;
        this.advertiserNeedAudit = advertiserNeedAudit;
        this.auditType = auditType;
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Boolean getAdvertiserNeedAudit() {
        return this.advertiserNeedAudit;
    }

    public Integer getAuditType() {
        return this.auditType;
    }

    public boolean sameAdxType(Integer type) {
        return !Objects.isNull(type) && Objects.equals(this.type, type);
    }

    public static AdxTypeEnum getByType(Integer type) {
        return Objects.isNull(type) ? null : (AdxTypeEnum)Stream.of(AdxTypeEnum.values()).filter(item -> Objects.equals(item.getType(), type)).findFirst().orElse(null);
    }

    public static Boolean needAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!adxType.equals(adxTypeEnum.getType())) continue;
            return Objects.equals(adxTypeEnum.getAuditType(), AuditTypeEnum.AUDIT.getCode());
        }
        return false;
    }

    public static Boolean contains(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType != adxTypeEnum.getType()) continue;
            return true;
        }
        return false;
    }

    public static AdxTypeEnum getEnumByType(Integer type) {
        for (AdxTypeEnum typeEnum : AdxTypeEnum.values()) {
            if (type != typeEnum.getType()) continue;
            return typeEnum;
        }
        return null;
    }

    public static Integer getAdxType(String adxName) {
        if (StringUtils.isBlank((String)adxName)) {
            return 0;
        }
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!adxTypeEnum.getName().equals(adxName)) continue;
            return adxTypeEnum.getType();
        }
        return 0;
    }

    public static Boolean advertiserNeedAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!adxType.equals(adxTypeEnum.getType())) continue;
            return adxTypeEnum.getAdvertiserNeedAudit();
        }
        return false;
    }

    public static List<Integer> getAllTypeList() {
        return Arrays.stream(AdxTypeEnum.values()).mapToInt(e -> e.getType()).boxed().collect(Collectors.toList());
    }

    public static List<Integer> getAllNeedAudit() {
        ArrayList needAudits = Lists.newArrayList();
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!AdxTypeEnum.needAudit(adxTypeEnum.getType()).booleanValue()) continue;
            needAudits.add(adxTypeEnum.getType());
        }
        return needAudits;
    }
}

