package cn.com.duiba.tuia.adx.center.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.AdxLogDTO;
import cn.com.duiba.tuia.adx.center.api.dto.IdeaMaterialUnitAuditDTO;

import java.util.List;

/**
 * @author liuyajun
 * @description
 * @data 2021/10/26
 */
@AdvancedFeignClient
public interface RemoteMateriaUnitExpireReportService {
    /**
     * 根据媒体ID查询未删除且审核通过的创意素材
     * @return
     */
    List<IdeaMaterialUnitAuditDTO> getMaterialUnitByMediaIds(List<Byte> mediaIds);

    /**
     * adx批量新增日志记录
     */
    boolean saveAdxLogs(List<AdxLogDTO> adxLogDTOs);

    /**
     * 批量修改创意素材审核记录表
     */
    boolean updateBatch(List<IdeaMaterialUnitAuditDTO> list);

    /**
     * 获取素材审核状态
     */
    void manualObtainAuditStatus();
}
