/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.account.impl;

import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.dao.account.AccountDAO;
import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.domain.dataobject.AccountDO;
import cn.com.duiba.tuia.exception.TuiaException;
import java.util.HashMap;
import java.util.Objects;
import org.springframework.stereotype.Repository;

@Repository(value="accountDAO")
public class AccountDAOImpl
extends TuiaBaseDao
implements AccountDAO {
    @Override
    public AccountDO selectAccountById(Long id) throws TuiaException {
        try {
            return (AccountDO)this.getSqlSession().selectOne(this.getStamentNameSpace("selectAccountById"), (Object)id);
        }
        catch (Exception e) {
            logger.error("AccountDAO.selectAccountById happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public int updateAccountMainType(Long accountId, Integer currentMainStatus) throws TuiaException {
        if (Objects.isNull(accountId) || Objects.isNull(currentMainStatus)) {
            throw new TuiaException(ErrorCode.E0100001.getErrorCode(), "\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            HashMap<String, Number> map = new HashMap<String, Number>(2);
            map.put("accountId", accountId);
            map.put("currentMainStatus", currentMainStatus);
            return this.getSqlSession().update(this.getStamentNameSpace("updateAccountMainType"), map);
        }
        catch (Exception e) {
            logger.error("AccountDAO.updateAccountMainType happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }
}

