/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.advert.impl;

import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.dao.advert.AdvertDAO;
import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.domain.dataobject.AdvertDO;
import cn.com.duiba.tuia.exception.TuiaException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository(value="advertDAO")
public class AdvertDAOImpl
extends TuiaBaseDao
implements AdvertDAO {
    @Override
    public int updateValidStatus(Long advertId, Integer status) throws TuiaException {
        try {
            HashMap param = Maps.newHashMap();
            param.put("advertId", advertId);
            param.put("status", status);
            param.put("times", System.currentTimeMillis());
            return this.getSqlSession().update(this.getStamentNameSpace("updateValidStatus"), (Object)param);
        }
        catch (Exception e) {
            logger.error("updateValidStatus happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public AdvertDO getAdvertById(Long id) throws TuiaException {
        try {
            return (AdvertDO)this.getSqlSession().selectOne(this.getStamentNameSpace("getAdvertById"), (Object)id);
        }
        catch (Exception e) {
            logger.error("getAdvertById happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public AdvertDO getAdvertNoRegionIdsById(Long id) throws TuiaException {
        try {
            return (AdvertDO)this.getSqlSession().selectOne(this.getStamentNameSpace("getAdvertNoRegionIdsById"), (Object)id);
        }
        catch (Exception e) {
            logger.error("getAdvertNoRegionIdsById happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public List<AdvertDO> queryValidAdvertIds() {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("queryValidAdvertIds"));
        }
        catch (Exception e) {
            logger.error("queryValidAdvertIds happen [DB] error!", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    @Override
    public List<Long> selectByAccountIds(List<Long> accountIds) {
        if (CollectionUtils.isEmpty(accountIds)) {
            return Collections.emptyList();
        }
        return this.getSqlSession().selectList(this.getStamentNameSpace("selectByAccountIds"), accountIds);
    }

    @Override
    public List<AdvertDO> queryAccountValidAdvertIds(Long accountId) {
        return this.getSqlSession().selectList(this.getStamentNameSpace("queryAccountValidAdvertIds"), (Object)accountId);
    }

    @Override
    public List<AdvertDO> getAdvertsByAdvertPlanId(Long advertPlanId) {
        return this.getSqlSession().selectList(this.getStamentNameSpace("getAdvertsByAdvertPlanId"), (Object)advertPlanId);
    }
}

