/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.engine.impl;

import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.dao.engine.AdvertOrderDAO;
import cn.com.duiba.tuia.domain.dataobject.AdvertOrderDO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.order.AdvertOrderHbaseRepository;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="advertOrderDAO")
public class AdvertOrderDAOImpl
extends TuiaBaseDao
implements AdvertOrderDAO {
    @Resource
    private AdvertOrderHbaseRepository orderHbaseRepository;

    @Override
    public int insert(AdvertOrderDO advertOrderDO) throws TuiaException {
        return this.orderHbaseRepository.insertOrder(advertOrderDO);
    }

    @Override
    public int saveTmpOrder(AdvertOrderDO advertOrderDO) throws TuiaException {
        return this.orderHbaseRepository.insertOrder(advertOrderDO, "tuia_adx_order_info_tmp");
    }

    @Override
    public int saveFormalOrder(AdvertOrderDO advertOrderDO) throws TuiaException {
        return this.orderHbaseRepository.insertOrder(advertOrderDO, "tuia_adx_order_info");
    }

    @Override
    public AdvertOrderDO getTmpOrder(String orderId) throws TuiaException {
        return this.orderHbaseRepository.findAdvertOrder(orderId, "tuia_adx_order_info_tmp");
    }

    @Override
    public AdvertOrderDO getFormalOrder(String orderId) throws TuiaException {
        return this.orderHbaseRepository.findAdvertOrder(orderId, "tuia_adx_order_info");
    }

    @Override
    public AdvertOrderDO getAdvertOrder(Long consumerId, String orderId) throws TuiaException {
        try {
            return this.orderHbaseRepository.findAdvertOrder(orderId);
        }
        catch (Exception ex) {
            logger.error("getAdvertOrderByOrderId happer [DB] error, the consumerId = [{}], orderId = [{}]", (Object)consumerId, (Object)orderId);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)ex);
        }
    }

    @Override
    public int batchInsertOrder(List<AdvertOrderDO> advertOrderDOList) throws TuiaException {
        if (CollectionUtils.isEmpty(advertOrderDOList)) {
            return 0;
        }
        try {
            boolean result = this.orderHbaseRepository.insertOrders(advertOrderDOList, "tuia_adx_order_info_tmp");
            if (!result) {
                logger.warn("hbase batchInsertOrder orderList error, result is not true");
                return 0;
            }
            return 1;
        }
        catch (Throwable e) {
            logger.error("hbase batchInsertOrder order error:", e);
            throw new TuiaException(ErrorCode.E0100001, e);
        }
    }
}

