/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.material.impl;

import cn.com.duiba.tuia.core.api.constant.RedisKeys;
import cn.com.duiba.tuia.core.api.dto.rsp.RspMaterialList;
import cn.com.duiba.tuia.dao.material.AdvertMaterialAppRelationDAO;
import cn.com.duiba.tuia.dao.material.AdvertMaterialDAO;
import cn.com.duiba.tuia.dao.material.AdvertMaterialRealtionService;
import cn.com.duiba.tuia.domain.dataobject.AdvertMaterialDto;
import cn.com.duiba.tuia.domain.vo.AdvertMaterialVO;
import cn.com.duiba.tuia.enums.NetworkTypeEnum;
import cn.com.duiba.tuia.enums.OperatorsEnum;
import cn.com.duiba.tuia.enums.PlatformTypeEnum;
import cn.com.duiba.tuia.utils.DateUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.tuia.advert.cache.CacheKeyTool;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AdvertMaterialRealtionServiceImpl
implements AdvertMaterialRealtionService {
    private static final Long OLD_MATERIAL_TRAFFIC = 90L;
    private static final Long OLD_MATERIAL_RATIO = 85L;
    private static final String DYNAMIC_NAME_PLACEHOLDER = "{\u52a8\u6001\u5185\u5bb9}";
    @Autowired
    private AdvertMaterialAppRelationDAO advertMaterialAppRelationDAO;
    @Autowired
    private AdvertMaterialDAO advertMaterialDAO;
    @Resource
    protected StringRedisTemplate stringRedisTemplate;

    @Override
    public void updateOldStatus(Long advertId, Long materialId, Long appId) {
        int rows = this.advertMaterialAppRelationDAO.updateNewOldStatus(materialId, appId, 0);
        if (rows == 1) {
            this.updateMaterialList(advertId, appId);
        }
    }

    @Override
    public Boolean isNewOfMaterial(Long advertId, Long materialId, Long appId) {
        int status;
        String key = CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K03, materialId, appId});
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((String)value)) {
            status = this.updateNewOldStatus(advertId, materialId, appId);
        } else {
            try {
                status = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.stringRedisTemplate.delete((Object)key);
                return true;
            }
        }
        return 1 == status;
    }

    @Override
    public AdvertMaterialVO getMaterialCache(Long materialId) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K06, materialId}));
        if (StringUtils.isBlank((String)value)) {
            AdvertMaterialVO advertMaterialCache = this.updateMaterialCache(materialId);
            return advertMaterialCache;
        }
        return (AdvertMaterialVO)JSONObject.parseObject((String)value, AdvertMaterialVO.class);
    }

    @Override
    public RspMaterialList getMaterialList(Long advertId, Long appId) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K04, advertId, appId}));
        if (StringUtils.isBlank((String)value)) {
            RspMaterialList rspMaterialList = this.updateMaterialList(advertId, appId);
            return rspMaterialList;
        }
        return (RspMaterialList)JSONObject.parseObject((String)value, RspMaterialList.class);
    }

    @Override
    public String getMaterialTitle(AdvertMaterialVO advertMaterialVO, String province, Integer netWork, Integer operator, String platform, String city) {
        String productName = advertMaterialVO.getProductName();
        if (advertMaterialVO.getProductNameTag() == null || advertMaterialVO.getProductNameTag() == 0 || StringUtils.isBlank((String)productName)) {
            return advertMaterialVO.getCouponName();
        }
        StringBuilder prefixes = new StringBuilder();
        switch (advertMaterialVO.getProductNameTag()) {
            case 1: {
                if (StringUtils.isBlank((String)province)) {
                    return advertMaterialVO.getCouponName();
                }
                prefixes.append(StringUtils.replace((String)province, (String)"\u7701", (String)""));
                break;
            }
            case 2: {
                if (null == netWork) {
                    return advertMaterialVO.getCouponName();
                }
                NetworkTypeEnum networkTypeEnum = NetworkTypeEnum.getByIndex((Integer)netWork);
                if (networkTypeEnum == null || networkTypeEnum == NetworkTypeEnum.OTHER) {
                    return advertMaterialVO.getCouponName();
                }
                prefixes.append(networkTypeEnum.getName());
                break;
            }
            case 3: {
                if (null == operator) {
                    return advertMaterialVO.getCouponName();
                }
                OperatorsEnum operatorsEnum = OperatorsEnum.getByCode((Integer)operator);
                if (operatorsEnum == null || operatorsEnum == OperatorsEnum.OTHER) {
                    return advertMaterialVO.getCouponName();
                }
                prefixes.append(operatorsEnum.getName());
                break;
            }
            case 4: {
                if (StringUtils.isBlank((String)platform)) {
                    return advertMaterialVO.getCouponName();
                }
                PlatformTypeEnum platformTypeEnum = PlatformTypeEnum.getByDesc((String)platform);
                if (platformTypeEnum == null || platformTypeEnum == PlatformTypeEnum.UNKNOW) {
                    return advertMaterialVO.getCouponName();
                }
                prefixes.append(platformTypeEnum.getcName());
                break;
            }
            case 5: {
                prefixes.append(DateUtil.getWeek());
                break;
            }
            case 6: {
                if (StringUtils.isBlank((String)city) && StringUtils.isBlank((String)province)) {
                    return advertMaterialVO.getCouponName();
                }
                city = StringUtils.replace((String)city, (String)"\u5e02", (String)"");
                province = StringUtils.replace((String)province, (String)"\u7701", (String)"");
                if (StringUtils.isNotBlank((String)city) && StringUtils.length((String)city) <= 3) {
                    prefixes.append(city);
                }
                if (!StringUtils.isNotBlank((String)city) || !StringUtils.isNotBlank((String)province) || StringUtils.length((String)city) <= 3) break;
                prefixes.append(province);
                break;
            }
        }
        if (StringUtils.isBlank((String)prefixes.toString())) {
            return advertMaterialVO.getCouponName();
        }
        if (StringUtils.contains((String)productName, (String)DYNAMIC_NAME_PLACEHOLDER)) {
            return StringUtils.replace((String)productName, (String)DYNAMIC_NAME_PLACEHOLDER, (String)prefixes.toString());
        }
        prefixes.append(productName);
        return prefixes.toString();
    }

    public AdvertMaterialVO updateMaterialCache(Long materialId) {
        AdvertMaterialDto material = this.advertMaterialDAO.selectById(materialId);
        if (null == material) {
            return null;
        }
        AdvertMaterialVO advertMaterialCache = new AdvertMaterialVO(material.getId(), material.getCouponName(), material.getBannerPng(), material.getButtonText(), material.getDescription());
        advertMaterialCache.setProductName(material.getProductName());
        advertMaterialCache.setProductNameTag(material.getProductNameTag());
        if (null != material.getPhotoId()) {
            advertMaterialCache.setAtmosphere(material.getAtmosphere());
            advertMaterialCache.setBgColour(material.getBgColour());
            advertMaterialCache.setBodyElement(material.getBodyElement());
            advertMaterialCache.setCarton(material.getCarton());
            advertMaterialCache.setInterception(material.getInterception());
            advertMaterialCache.setIsPrevalent(material.getIsPrevalent());
        }
        this.stringRedisTemplate.opsForValue().set((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K06, materialId}), (Object)JSONObject.toJSONString((Object)advertMaterialCache), 1L, TimeUnit.HOURS);
        return advertMaterialCache;
    }

    private int updateNewOldStatus(Long advertId, Long materialId, Long appId) {
        Integer newOldStatus = this.advertMaterialAppRelationDAO.selectNewOldStatus(materialId, appId);
        if (newOldStatus == null) {
            newOldStatus = 1;
            this.stringRedisTemplate.opsForValue().set((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K03, materialId, appId}), (Object)newOldStatus.toString(), (long)DateUtils.getToTomorrowSeconds() + (long)new Random().nextInt(10), TimeUnit.SECONDS);
            this.insert(advertId, materialId, appId);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K03, materialId, appId}), (Object)newOldStatus.toString(), (long)DateUtils.getToTomorrowSeconds() + (long)new Random().nextInt(10), TimeUnit.SECONDS);
        }
        return newOldStatus;
    }

    private boolean insert(Long advertId, Long materialId, Long appId) {
        boolean isSuccess;
        if (this.stringRedisTemplate.opsForValue().get((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K08, materialId, appId})) != null) {
            return true;
        }
        this.stringRedisTemplate.opsForValue().set((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K08, materialId, appId}), (Object)"true", 10L, TimeUnit.SECONDS);
        boolean bl = isSuccess = this.advertMaterialAppRelationDAO.insert(advertId, materialId, appId) == 1;
        if (isSuccess) {
            this.updateMaterialList(advertId, appId);
        }
        return isSuccess;
    }

    private RspMaterialList updateMaterialList(Long advertId, Long appId) {
        List<Long> activatedIds = this.advertMaterialDAO.getAvailableMaterialIdsByAdvertId(advertId);
        RspMaterialList rspMaterialList = new RspMaterialList();
        if (CollectionUtils.isNotEmpty(activatedIds)) {
            List<Long> oldIds = this.advertMaterialAppRelationDAO.selectIdsByStatus(advertId, appId, 0);
            oldIds.retainAll(activatedIds);
            rspMaterialList.setOldMaterials(oldIds);
            activatedIds.removeAll(oldIds);
            rspMaterialList.setNewMaterials(activatedIds);
        }
        rspMaterialList.setOldMaterialTraffic(OLD_MATERIAL_TRAFFIC);
        rspMaterialList.setOldMaterialRatio(OLD_MATERIAL_RATIO);
        this.stringRedisTemplate.opsForValue().set((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K04, advertId, appId}), (Object)JSONObject.toJSONString((Object)rspMaterialList), 1L, TimeUnit.HOURS);
        return rspMaterialList;
    }
}

