/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.resource_tags.impl;

import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.dao.resource_tags.ResourceTagsDAO;
import cn.com.duiba.tuia.domain.dataobject.ResoureTagsDO;
import cn.com.duiba.tuia.exception.TuiaException;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository(value="resourceTagsDAO")
public class ResourceTagsDAOImpl
extends TuiaBaseDao
implements ResourceTagsDAO {
    @Override
    public ResoureTagsDO selectResoureTagsDOById(Long resourceId, String type) throws TuiaException {
        try {
            HashMap param = Maps.newHashMap();
            param.put("resourceId", resourceId);
            param.put("type", type);
            return (ResoureTagsDO)this.getSqlSession().selectOne(this.getStamentNameSpace("selectResoureTagsDOById"), (Object)param);
        }
        catch (Exception e) {
            logger.error("ResourceTagsDAO.selectResoureTagsDOById happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public List<ResoureTagsDO> selectResoureTagsDOByType(@Param(value="type") String type) throws TuiaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectResoureTagsDOByType"), (Object)type);
        }
        catch (Exception e) {
            logger.error("ResourceTagsDAO.selectResoureTagsDOByType happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public List<Long> selectResoureTagsDOByTagNum(String tagNum, String type) throws TuiaException {
        try {
            HashMap param = Maps.newHashMap();
            param.put("tagNum", tagNum);
            param.put("type", type);
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectResoureTagsDOByTagNum"), (Object)param);
        }
        catch (Exception e) {
            logger.error("ResourceTagsDAO.selectResoureTagsDOByTagNum happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }
}

