/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.order;

import cn.com.duiba.bigdata.common.biz.utils.HbaseDataUtil;
import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.domain.dataobject.AdvertOrderDO;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.order.enums.OrderHbaseCollEnum;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.utils.OrderRowKeyUtils;
import com.netflix.hystrix.contrib.javanica.annotation.DefaultProperties;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@DefaultProperties(groupKey="Engine", threadPoolKey="AdvertOrderHbaseRepository", threadPoolProperties={@HystrixProperty(name="coreSize", value="20"), @HystrixProperty(name="maxQueueSize", value="20")}, commandProperties={@HystrixProperty(name="execution.isolation.thread.timeoutInMilliseconds", value="200")})
@Repository
public class AdvertOrderHbaseRepository
extends TuiaBaseDao {
    @Resource(name="adxOrderHbaseDataUtil")
    private HbaseDataUtil adxOrderHbaseDataUtil;
    private static final String ORDER_TABLE = "tuia_order_info";
    private static final String COLL_FAMILY = "cf";

    @HystrixCommand(commandKey="insertOrder", fallbackMethod="insertWithMysql")
    public int insertOrder(AdvertOrderDO advertOrderDO) throws TuiaException {
        return this.insertOrder(advertOrderDO, ORDER_TABLE);
    }

    @HystrixCommand(commandKey="insertOrder", fallbackMethod="insertWithMysql")
    public int insertOrder(AdvertOrderDO advertOrderDO, String table) throws TuiaException {
        try {
            boolean result = this.insertHbase(advertOrderDO, table);
            if (!result) {
                logger.warn("hbase insert order error, result is not true");
                return 0;
            }
            return 1;
        }
        catch (Throwable e) {
            logger.error("hbase insert order error:", e);
            throw new TuiaException(ErrorCode.E0100001, e);
        }
    }

    @HystrixCommand(commandKey="insertOrders", fallbackMethod="insertBatchHbaseTimeOut")
    public boolean insertOrders(List<AdvertOrderDO> orderDOList, String tableName) {
        boolean result;
        HashMap<String, Map<String, String>> rowKeyMap = new HashMap<String, Map<String, String>>();
        for (AdvertOrderDO advertOrderDO : orderDOList) {
            String rowKey = OrderRowKeyUtils.genRowKey((String)advertOrderDO.getDuibaOrderId());
            rowKeyMap.put(rowKey, this.buildMap(advertOrderDO));
        }
        try {
            result = this.adxOrderHbaseDataUtil.insert(tableName, rowKeyMap);
        }
        catch (Exception e) {
            logger.error("orderHbase insert error, orderIds={}", orderDOList.stream().map(AdvertOrderDO::getDuibaOrderId).collect(Collectors.toList()), (Object)e);
            CatUtil.log((String)CatGroupEnum.CAT_109001.getCode());
            result = false;
        }
        return result;
    }

    private boolean insertHbase(AdvertOrderDO advertOrderDO, String table) {
        boolean result;
        try {
            result = this.adxOrderHbaseDataUtil.insert(table, OrderRowKeyUtils.genRowKey((String)advertOrderDO.getDuibaOrderId()), this.buildMap(advertOrderDO));
        }
        catch (Exception e) {
            logger.error("orderHbase insert error, orderId={}", (Object)advertOrderDO.getDuibaOrderId(), (Object)e);
            CatUtil.log((String)CatGroupEnum.CAT_109001.getCode());
            result = false;
        }
        return result;
    }

    private Map<String, String> buildMap(AdvertOrderDO advertOrderDO) {
        HashMap<String, String> row = new HashMap<String, String>();
        row.put(OrderHbaseCollEnum.COLL_ID.getColl(), OrderHbaseCollEnum.COLL_ID.handleCollKeyString(advertOrderDO));
        row.put(OrderHbaseCollEnum.COLL_CONSUMER.getColl(), OrderHbaseCollEnum.COLL_CONSUMER.handleCollKeyString(advertOrderDO));
        row.put(OrderHbaseCollEnum.COLL_APP.getColl(), OrderHbaseCollEnum.COLL_APP.handleCollKeyString(advertOrderDO));
        row.put(OrderHbaseCollEnum.COLL_SLOT.getColl(), OrderHbaseCollEnum.COLL_SLOT.handleCollKeyString(advertOrderDO));
        row.put(OrderHbaseCollEnum.COLL_ACTIVITY.getColl(), OrderHbaseCollEnum.COLL_ACTIVITY.handleCollKeyString(advertOrderDO));
        row.put(OrderHbaseCollEnum.COLL_ADVERT.getColl(), OrderHbaseCollEnum.COLL_ADVERT.handleCollKeyString(advertOrderDO));
        row.put(OrderHbaseCollEnum.COLL_MATERIAL.getColl(), OrderHbaseCollEnum.COLL_MATERIAL.handleCollKeyString(advertOrderDO));
        row.put(OrderHbaseCollEnum.COLL_PROMOTE_URL.getColl(), OrderHbaseCollEnum.COLL_PROMOTE_URL.handleCollKeyString(advertOrderDO));
        row.put(OrderHbaseCollEnum.COLL_GMT_CREATE.getColl(), OrderHbaseCollEnum.COLL_GMT_CREATE.handleCollKeyString(advertOrderDO));
        row.put(OrderHbaseCollEnum.COLL_GMT_MODIFIED.getColl(), OrderHbaseCollEnum.COLL_GMT_MODIFIED.handleCollKeyString(advertOrderDO));
        row.put(OrderHbaseCollEnum.COLL_REST.getColl(), OrderHbaseCollEnum.COLL_REST.handleCollKeyString(advertOrderDO));
        row.put(OrderHbaseCollEnum.COLL_JSON.getColl(), OrderHbaseCollEnum.COLL_JSON.handleCollKeyString(advertOrderDO));
        if (advertOrderDO.getFilterResultLogJson() != null) {
            row.put(OrderHbaseCollEnum.COLL_FILOG.getColl(), OrderHbaseCollEnum.COLL_FILOG.handleCollKeyString(advertOrderDO));
        }
        return row;
    }

    private Put buildRow(AdvertOrderDO advertOrderDO) {
        String rowKey = OrderRowKeyUtils.genRowKey((String)advertOrderDO.getDuibaOrderId());
        Put row = new Put(rowKey.getBytes());
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_ID.getColl().getBytes(), OrderHbaseCollEnum.COLL_ID.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_CONSUMER.getColl().getBytes(), OrderHbaseCollEnum.COLL_CONSUMER.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_APP.getColl().getBytes(), OrderHbaseCollEnum.COLL_APP.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_SLOT.getColl().getBytes(), OrderHbaseCollEnum.COLL_SLOT.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_ACTIVITY.getColl().getBytes(), OrderHbaseCollEnum.COLL_ACTIVITY.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_ADVERT.getColl().getBytes(), OrderHbaseCollEnum.COLL_ADVERT.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_MATERIAL.getColl().getBytes(), OrderHbaseCollEnum.COLL_MATERIAL.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_PROMOTE_URL.getColl().getBytes(), OrderHbaseCollEnum.COLL_PROMOTE_URL.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_GMT_CREATE.getColl().getBytes(), OrderHbaseCollEnum.COLL_GMT_CREATE.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_GMT_MODIFIED.getColl().getBytes(), OrderHbaseCollEnum.COLL_GMT_MODIFIED.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_REST.getColl().getBytes(), OrderHbaseCollEnum.COLL_REST.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_JSON.getColl().getBytes(), OrderHbaseCollEnum.COLL_JSON.handleCollKey(advertOrderDO));
        if (advertOrderDO.getFilterResultLogJson() != null) {
            row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_FILOG.getColl().getBytes(), OrderHbaseCollEnum.COLL_FILOG.handleCollKey(advertOrderDO));
        }
        return row;
    }

    private boolean insertBatchHbaseTimeOut(List<AdvertOrderDO> orderDOList, String tableName) {
        logger.warn("inserOrders timeout fallback  orderIds={}", orderDOList.stream().map(AdvertOrderDO::getDuibaOrderId).collect(Collectors.toList()));
        return false;
    }

    private int insertWithMysql(AdvertOrderDO advertOrderDO) {
        logger.warn("orderHbase insert fallback with mysql orderId={}", (Object)advertOrderDO.getDuibaOrderId());
        return 0;
    }

    private int insertWithMysql(AdvertOrderDO advertOrderDO, String table) {
        logger.warn("orderHbase insert fallback with mysql orderId={}", (Object)advertOrderDO.getDuibaOrderId());
        return 0;
    }

    @HystrixCommand(commandKey="findAdvertOrder", fallbackMethod="findWithMysql")
    public AdvertOrderDO findAdvertOrder(String orderId) {
        AdvertOrderDO adxOrderDO = this.findAdvertOrder(orderId, "tuia_adx_order_info");
        if (adxOrderDO != null && adxOrderDO.getAdvertId() != null) {
            return adxOrderDO;
        }
        CatUtil.log((String)CatGroupEnum.CAT_112001.getCode());
        AdvertOrderDO tmpAdvertOrder = this.findAdvertOrder(orderId, "tuia_adx_order_info_tmp");
        if (tmpAdvertOrder != null && tmpAdvertOrder.getAdvertId() != null) {
            return tmpAdvertOrder;
        }
        CatUtil.log((String)CatGroupEnum.CAT_112002.getCode());
        AdvertOrderDO advertOrder = this.findAdvertOrder(orderId, ORDER_TABLE);
        if (advertOrder != null && advertOrder.getAdvertId() != null) {
            return advertOrder;
        }
        CatUtil.log((String)CatGroupEnum.CAT_112003.getCode());
        return null;
    }

    @HystrixCommand(commandKey="findAdvertOrder", fallbackMethod="findWithMysql")
    public AdvertOrderDO findAdvertOrder(String orderId, String table) {
        try {
            String rowKey = OrderRowKeyUtils.genRowKey((String)orderId);
            Map row = this.adxOrderHbaseDataUtil.getRow(table, rowKey);
            if (CollectionUtils.isEmpty((Map)row)) {
                return null;
            }
            AdvertOrderDO orderDO = this.buildOrderDO(row);
            orderDO.setDuibaOrderId(orderId);
            return orderDO;
        }
        catch (Throwable e) {
            logger.error("orderHbase findByOrderId error", e);
            CatUtil.log((String)CatGroupEnum.CAT_109002.getCode());
            return null;
        }
    }

    private AdvertOrderDO findWithMysql(String orderId) {
        logger.warn("orderHbase getAdvertOrderByOrderId fallback with mysql orderId={}", (Object)orderId);
        return null;
    }

    private AdvertOrderDO findWithMysql(String orderId, String table) {
        logger.warn("orderHbase getAdvertOrderByOrderId fallback with mysql orderId={}", (Object)orderId);
        return null;
    }

    private AdvertOrderDO buildOrderDO(Map<String, String> row) {
        AdvertOrderDO advertOrderDO = new AdvertOrderDO();
        for (Map.Entry<String, String> entry : row.entrySet()) {
            OrderHbaseCollEnum.getByColl(entry.getKey()).handleCollValue(advertOrderDO, entry.getValue());
        }
        return advertOrderDO;
    }

    private AdvertOrderDO buildOrderDO(Result result) {
        AdvertOrderDO advertOrderDO = new AdvertOrderDO();
        Cell[] cells = result.rawCells();
        Stream.of(cells).forEach(cell -> {
            String collKey = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            String collValue = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            OrderHbaseCollEnum.getByColl(collKey).handleCollValue(advertOrderDO, collValue);
        });
        return advertOrderDO;
    }
}

