/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.order.enums;

import cn.com.duiba.tuia.domain.dataobject.AdvertOrderDO;
import cn.com.duiba.tuia.order.OrderHbaseCollHandle;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.util.Strings;

public enum OrderHbaseCollEnum implements OrderHbaseCollHandle
{
    COLL_ID("id", "id"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)(orderDO.getId() + ""));
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return orderDO.getId() + "";
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            orderDO.setId(Long.valueOf(value));
        }
    }
    ,
    COLL_CONSUMER("cm", "\u7528\u6237id"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)(orderDO.getConsumerId() + ""));
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return orderDO.getConsumerId() + "";
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            orderDO.setConsumerId(Long.valueOf(value));
        }
    }
    ,
    COLL_APP("ap", "appId"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)(orderDO.getAppId() + ""));
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return orderDO.getAppId() + "";
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            orderDO.setAppId(Long.valueOf(value));
        }
    }
    ,
    COLL_SLOT("st", "slotId"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)(orderDO.getSlotId() + ""));
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return orderDO.getSlotId() + "";
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            orderDO.setSlotId(Long.valueOf(value));
        }
    }
    ,
    COLL_ACTIVITY("at", "\u6d3b\u52a8id"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)(orderDO.getDuibaActivityId() + ""));
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return orderDO.getDuibaActivityId() + "";
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            orderDO.setDuibaActivityId(Long.valueOf(value));
        }
    }
    ,
    COLL_ADVERT("ad", "\u8ba1\u5212id"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)(orderDO.getAdvertId() + ""));
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return orderDO.getAdvertId() + "";
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            orderDO.setAdvertId(Long.valueOf(value));
        }
    }
    ,
    COLL_MATERIAL("ml", "\u7d20\u6750id"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)(orderDO.getMaterialId() + ""));
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return orderDO.getMaterialId() + "";
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            orderDO.setMaterialId(Long.valueOf(value));
        }
    }
    ,
    COLL_GMT_CREATE("gtc", "\u521b\u5efa\u65f6\u95f4"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)DateUtils.getSecondStr((Date)orderDO.getGmtCreate()));
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return DateUtils.getSecondStr((Date)orderDO.getGmtCreate());
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            orderDO.setGmtCreate(DateUtils.getSecondDate((String)value));
        }
    }
    ,
    COLL_GMT_MODIFIED("gtm", "\u4fee\u6539\u65f6\u95f4"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)DateUtils.getSecondStr((Date)orderDO.getGmtCreate()));
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return DateUtils.getSecondStr((Date)orderDO.getGmtCreate());
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            orderDO.setGmtModified(DateUtils.getSecondDate((String)value));
        }
    }
    ,
    COLL_PROMOTE_URL("ptu", "\u7d20\u6750\u94fe\u63a5"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)orderDO.getPromoteUrl());
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return orderDO.getPromoteUrl();
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            orderDO.setPromoteUrl(value);
        }
    }
    ,
    COLL_REST("rs", "\u5176\u4ed6\u5b57\u6bb5"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)OrderHbaseCollEnum.packJsonFields(orderDO));
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return OrderHbaseCollEnum.packJsonFields(orderDO);
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            OrderHbaseCollEnum.parseRestFields(orderDO, value);
        }
    }
    ,
    COLL_JSON("js", "\u5927json"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)orderDO.getJson());
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return orderDO.getJson();
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            orderDO.setJson(value);
        }
    }
    ,
    COLL_FILOG("fi_log", "79filterResult\u65e5\u5fd7"){

        @Override
        public byte[] handleCollKey(AdvertOrderDO orderDO) {
            return Strings.getBytesUtf8((String)orderDO.getFilterResultLogJson());
        }

        @Override
        public String handleCollKeyString(AdvertOrderDO orderDO) {
            return orderDO.getFilterResultLogJson();
        }

        @Override
        public void handleCollValue(AdvertOrderDO orderDO, String value) {
            orderDO.setFilterResultLogJson(value);
        }
    };

    private String coll;
    private String desc;

    private OrderHbaseCollEnum(String coll, String desc) {
        this.coll = coll;
        this.desc = desc;
    }

    private static String packJsonFields(AdvertOrderDO advertOrderDO) {
        String ua = advertOrderDO.getUa();
        Integer couponType = advertOrderDO.getCouponType();
        String couponCode = advertOrderDO.getCouponCode();
        String couponPasswd = advertOrderDO.getCouponPasswd();
        Integer charge = advertOrderDO.getIsCharge();
        String overDue = advertOrderDO.getOverDue();
        JSONObject object = new JSONObject();
        object.put("ua", (Object)ua);
        object.put("couponType", (Object)couponType);
        object.put("couponCode", (Object)couponCode);
        object.put("couponPasswd", (Object)couponPasswd);
        object.put("charge", (Object)charge);
        object.put("overDue", (Object)overDue);
        return object.toJSONString();
    }

    private static void parseRestFields(AdvertOrderDO orderDO, String value) {
        if (StringUtils.isBlank((String)value) || orderDO == null) {
            return;
        }
        JSONObject object = JSON.parseObject((String)value);
        orderDO.setUa(object.getString("ua"));
        orderDO.setCouponType(object.getInteger("couponType"));
        orderDO.setCouponCode(object.getString("couponCode"));
        orderDO.setCouponPasswd(object.getString("couponPasswd"));
        orderDO.setIsCharge(object.getInteger("charge"));
        orderDO.setOverDue(object.getString("overDue"));
    }

    public static OrderHbaseCollEnum getByColl(String coll) {
        return Stream.of(OrderHbaseCollEnum.values()).filter(e -> e.getColl().equalsIgnoreCase(coll)).findFirst().orElse(null);
    }

    public String getColl() {
        return this.coll;
    }

    public String getDesc() {
        return this.desc;
    }
}

