package cn.com.duiba.tuia.adx.proxy.service.api.constant;

import java.util.Objects;
import java.util.stream.Stream;

public enum AdxTypeEnum {

    IQIYI(12, "iqiyi");

    int code;

    String name;

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public void setCode(int code) {
        this.code = code;
    }

    AdxTypeEnum(int code, String name){
        this.code = code;
        this.name = name;
    }

    public static AdxTypeEnum getByCode(int code){
        return Objects.isNull(code)
                ? null
                : Stream.of(AdxTypeEnum.values())
                .filter(item -> Objects.equals(item.getCode(), code))
                .findFirst().orElse(null);
    }
}
